/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core.review;

import cn.hutool.core.util.StrUtil;
import com.ovopark.check.core.CheckTaskRecordStatusEnum;
import com.ovopark.check.core.CheckTaskResult;
import com.ovopark.check.core.review.BlockCondition;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class PriorityBlockCondition
extends BlockCondition {
    private final Integer count;
    private final Integer priority;
    private final CheckTaskRecordStatusEnum status = CheckTaskRecordStatusEnum.UNQUALIFIED;

    public PriorityBlockCondition(CheckTaskResult result, Integer count, Integer priority) {
        super(result);
        this.count = count;
        this.priority = priority;
    }

    @Override
    public boolean match() {
        List unqualifedRecords = this.result.getCheckTask().getRecords().stream().filter(e -> e.getStatus() == this.status).collect(Collectors.toList());
        long matchCount = unqualifedRecords.stream().filter(e -> this.priority == null || Objects.equals(this.priority, 0) || Objects.equals(e.getInspectionItem().getPriority(), this.priority)).count();
        return matchCount > (long)this.count.intValue();
    }

    @Override
    public String prettyString() {
        List unqualifedRecords = this.result.getCheckTask().getRecords().stream().filter(e -> e.getStatus() == this.status).collect(Collectors.toList());
        long matchCount = unqualifedRecords.stream().filter(e -> Objects.equals(e.getInspectionItem().getPriority(), this.priority)).count();
        return StrUtil.format((CharSequence)" [\u4f18\u5148\u7ea7:{} \u4e2a\u6570:{}, \u5339\u914d\u7684\u4e2a\u6570{},\u5339\u914d:{}] ", (Object[])new Object[]{this.priority, this.count, matchCount, this.match()});
    }
}

