/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core.calculator;

import com.ovopark.check.core.Score;
import com.ovopark.check.core.scoring.ScoringBlocker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtraScoringCalculator {
    private static final Logger log = LoggerFactory.getLogger(ExtraScoringCalculator.class);
    private ScoringBlocker blocker;
    private Integer triggerType;
    private Integer percent;

    public Score calculate(Score score) {
        if (this.match(score.getScore(), false)) {
            this.extraScoring(score, false);
        }
        if (this.match(score.getReturnScore(), true)) {
            this.extraScoring(score, true);
        }
        return score;
    }

    private boolean match(Double score, boolean isReturnScore) {
        return this.blocker.match(score, isReturnScore);
    }

    private void extraScoring(Score score, Boolean isReturnScore) {
        switch (this.triggerType) {
            case 0: {
                if (isReturnScore.booleanValue()) {
                    score.setReturnScore(0.0);
                    break;
                }
                score.setScore(0.0);
                break;
            }
            case 1: {
                if (isReturnScore.booleanValue()) {
                    score.setReturnScore(score.getReturnScore() * (double)this.percent.intValue() / 100.0);
                    break;
                }
                score.setScore(score.getScore() * (double)this.percent.intValue() / 100.0);
            }
        }
    }

    public ScoringBlocker getBlocker() {
        return this.blocker;
    }

    public Integer getTriggerType() {
        return this.triggerType;
    }

    public Integer getPercent() {
        return this.percent;
    }

    public void setBlocker(ScoringBlocker blocker) {
        this.blocker = blocker;
    }

    public void setTriggerType(Integer triggerType) {
        this.triggerType = triggerType;
    }

    public void setPercent(Integer percent) {
        this.percent = percent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtraScoringCalculator)) {
            return false;
        }
        ExtraScoringCalculator other = (ExtraScoringCalculator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScoringBlocker this$blocker = this.getBlocker();
        ScoringBlocker other$blocker = other.getBlocker();
        if (this$blocker == null ? other$blocker != null : !this$blocker.equals(other$blocker)) {
            return false;
        }
        Integer this$triggerType = this.getTriggerType();
        Integer other$triggerType = other.getTriggerType();
        if (this$triggerType == null ? other$triggerType != null : !((Object)this$triggerType).equals(other$triggerType)) {
            return false;
        }
        Integer this$percent = this.getPercent();
        Integer other$percent = other.getPercent();
        return !(this$percent == null ? other$percent != null : !((Object)this$percent).equals(other$percent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExtraScoringCalculator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScoringBlocker $blocker = this.getBlocker();
        result = result * 59 + ($blocker == null ? 43 : $blocker.hashCode());
        Integer $triggerType = this.getTriggerType();
        result = result * 59 + ($triggerType == null ? 43 : ((Object)$triggerType).hashCode());
        Integer $percent = this.getPercent();
        result = result * 59 + ($percent == null ? 43 : ((Object)$percent).hashCode());
        return result;
    }

    public String toString() {
        return "ExtraScoringCalculator(blocker=" + this.getBlocker() + ", triggerType=" + this.getTriggerType() + ", percent=" + this.getPercent() + ")";
    }

    public ExtraScoringCalculator() {
    }

    public ExtraScoringCalculator(ScoringBlocker blocker, Integer triggerType, Integer percent) {
        this.blocker = blocker;
        this.triggerType = triggerType;
        this.percent = percent;
    }
}

