/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core.scoring;

import com.ovopark.check.core.scoring.ScoringBlockCondition;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class ScoringBlocker {
    private List<ScoringBlockCondition> conditions;
    private String logic;

    public boolean match(Double score, Boolean isReturnScore) {
        if (Objects.equals("and", this.logic)) {
            return this.and(this.conditions, score, isReturnScore);
        }
        if (Objects.equals("or", this.logic)) {
            return this.or(this.conditions, score, isReturnScore);
        }
        return true;
    }

    public boolean and(List<ScoringBlockCondition> conditions, Double score, Boolean isReturnScore) {
        return conditions.stream().allMatch(conditions1 -> conditions1.match(score, isReturnScore));
    }

    public boolean or(List<ScoringBlockCondition> conditions, Double score, Boolean isReturnScore) {
        return conditions.stream().anyMatch(conditions1 -> conditions1.match(score, isReturnScore));
    }

    public String prettyString(Double score, Boolean isReturnScore) {
        if (CollectionUtils.isEmpty(this.conditions)) {
            return "ALWAYS_MATCH";
        }
        return "[match]:" + this.match(score, isReturnScore) + "\n" + this.conditions.stream().map(c -> c.prettyString(score, isReturnScore)).collect(Collectors.joining("\n" + this.logic.toUpperCase()));
    }

    public ScoringBlocker(List<ScoringBlockCondition> conditions, String logic) {
        this.conditions = conditions;
        this.logic = logic;
    }
}

