/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core;

import com.ovopark.check.core.CheckTask;
import com.ovopark.check.core.CheckTaskSourceEnum;
import com.ovopark.check.core.CheckTaskTypeEnum;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class CheckConvertor {
    public static Integer convertCheckType(CheckTaskTypeEnum type, CheckTaskSourceEnum source) {
        if (CheckTaskSourceEnum.PLAN == source) {
            if (type.getCode() == 0) {
                return 10;
            }
            if (type.getCode() == 1) {
                return 11;
            }
            if (type.getCode() == 12) {
                return 17;
            }
            return type.getCode();
        }
        if (CheckTaskSourceEnum.TASK == source) {
            if (type.getCode() == 0) {
                return 15;
            }
            if (type.getCode() == 1) {
                return 21;
            }
        }
        return type.getCode();
    }

    public static Integer getSourceType(int type, int source) {
        int sourceType = 8;
        switch (CheckConvertor.convertCheckType(CheckTaskTypeEnum.of(type), CheckTaskSourceEnum.of(source))) {
            case 2: {
                sourceType = 1;
                break;
            }
            case 1: 
            case 5: {
                sourceType = 9;
                break;
            }
            case 10: {
                sourceType = 14;
                break;
            }
            case 11: {
                sourceType = 13;
                break;
            }
            case 15: {
                sourceType = 15;
                break;
            }
            case 12: {
                sourceType = 12;
                break;
            }
            case 17: {
                sourceType = 17;
                break;
            }
            case 21: {
                sourceType = 21;
                break;
            }
            case 22: {
                sourceType = 22;
                break;
            }
        }
        return sourceType;
    }

    public static Integer getSourceType(CheckTask task) {
        int sourceType = 8;
        switch (CheckConvertor.convertCheckType(task.getType(), task.getSource())) {
            case 2: {
                sourceType = 1;
                break;
            }
            case 1: 
            case 5: {
                sourceType = 9;
                break;
            }
            case 10: {
                sourceType = 14;
                break;
            }
            case 11: {
                sourceType = 13;
                break;
            }
            case 15: {
                sourceType = 15;
                break;
            }
            case 12: {
                sourceType = 12;
                break;
            }
            case 17: {
                sourceType = 17;
                break;
            }
            case 21: {
                sourceType = 21;
                break;
            }
            case 22: {
                sourceType = 22;
                break;
            }
        }
        return sourceType;
    }

    public static CheckTaskTypeEnum getCheckTypeFromDb(Integer checkType) {
        if (checkType == 10) {
            return CheckTaskTypeEnum.LIVE_CHECK;
        }
        if (checkType == 11) {
            return CheckTaskTypeEnum.REMOTE_CHECK;
        }
        if (checkType == 17) {
            return CheckTaskTypeEnum.SELF_CHECK;
        }
        if (checkType == 15) {
            return CheckTaskTypeEnum.LIVE_CHECK;
        }
        if (checkType == 21) {
            return CheckTaskTypeEnum.REMOTE_CHECK;
        }
        return CheckTaskTypeEnum.of(checkType);
    }

    public static CheckTaskSourceEnum getCheckSourceFromDb(Integer checkType) {
        if (checkType == 10 || checkType == 11 || checkType == 17 || checkType == 22) {
            return CheckTaskSourceEnum.PLAN;
        }
        if (checkType == 15 || checkType == 21) {
            return CheckTaskSourceEnum.TASK;
        }
        return CheckTaskSourceEnum.NORMAL;
    }

    public static int getBaseSourceType(Integer sourceType) {
        switch (sourceType) {
            case 13: 
            case 21: {
                return 9;
            }
            case 14: 
            case 15: {
                return 8;
            }
            case 17: {
                return 12;
            }
        }
        return sourceType;
    }

    public static Double calMoney(Integer moneyType, Double money) {
        if (moneyType != null && money != null) {
            if (moneyType == 0) {
                return money;
            }
            return -money.doubleValue();
        }
        return 0.0;
    }

    public static List<Integer> convertSourceTypes2CheckTypes(List<Integer> sourceTypes, Boolean notContainSpotCheck) {
        ArrayList<Integer> checkTypes = new ArrayList<Integer>();
        if (sourceTypes == null || sourceTypes.isEmpty()) {
            return checkTypes;
        }
        HashSet<Integer> sourceTypesSet = new HashSet<Integer>(sourceTypes);
        if (sourceTypesSet.contains(8)) {
            checkTypes.add(0);
        }
        if (sourceTypesSet.contains(14)) {
            checkTypes.add(10);
        }
        if (sourceTypesSet.contains(15)) {
            checkTypes.add(15);
        }
        if (sourceTypesSet.contains(9)) {
            checkTypes.add(1);
        }
        if (sourceTypesSet.contains(13)) {
            checkTypes.add(11);
        }
        if (sourceTypesSet.contains(21)) {
            checkTypes.add(21);
        }
        if (notContainSpotCheck != null && notContainSpotCheck.booleanValue() && sourceTypesSet.contains(1)) {
            checkTypes.add(-1);
        }
        if (sourceTypesSet.contains(12)) {
            checkTypes.add(12);
        }
        if (sourceTypesSet.contains(17)) {
            checkTypes.add(17);
        }
        if (sourceTypesSet.contains(22)) {
            checkTypes.add(22);
        }
        return checkTypes;
    }

    public static Integer getMainTypeFromCheckType(Integer cmdCheckType) {
        Integer mainType = null;
        switch (cmdCheckType) {
            case 0: {
                mainType = 8;
                break;
            }
            case 1: {
                mainType = 9;
                break;
            }
            case 12: {
                mainType = 7;
                break;
            }
        }
        return mainType;
    }

    public static String convertInspTaskType(CheckTaskTypeEnum type) {
        if (type == CheckTaskTypeEnum.LIVE_CHECK) {
            return "INSP-TASK-TYPE_LIVE";
        }
        if (type == CheckTaskTypeEnum.SELF_CHECK) {
            return "INSP-TASK-TYPE_SELF";
        }
        if (type == CheckTaskTypeEnum.REMOTE_CHECK) {
            return "INSP-TASK-TYPE_REMOTE";
        }
        if (type == CheckTaskTypeEnum.INSP_CHECK) {
            return "INSP-TASK-TYPE_SCENE";
        }
        if (type == CheckTaskTypeEnum.AI_CHECK) {
            return "INSP-TASK-TYPE_AI";
        }
        return null;
    }

    public static String sourceTypeToMatchElementSource(Integer sourceType) {
        switch (sourceType) {
            case 1: {
                return "SOURCE_SCENE";
            }
            case 2: {
                return "SOURCE_RANDOM";
            }
            case 3: {
                return "SOURCE_CAPTURE";
            }
            case 4: {
                return "SOURCE_HAND";
            }
            case 6: {
                return "SOURCE_SNAPSHOT";
            }
            case 7: {
                return "SOURCE_ALARM";
            }
            case 8: 
            case 14: 
            case 15: {
                return "SOURCE_LIVE";
            }
            case 9: 
            case 13: 
            case 21: {
                return "SOURCE_REMOTE";
            }
            case 12: 
            case 17: {
                return "SOURCE_SELF";
            }
            case 16: {
                return "SOURCE_BIRD";
            }
            case 10: 
            case 11: {
                return "SOURCE_AI";
            }
            case 22: {
                return "SOURCE_TASK_AI";
            }
        }
        return "";
    }
}

