package com.ovopark.api;

import com.ovopark.check.R;
import com.ovopark.check.problem.*;
import com.ovopark.check.Vo.ProblemInfoOfHomePageSearchInfo;
import com.ovopark.pojo.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;

/**
 * @ClassName CheckProblemsApi
 * @Description 代办单api
 * @Author yangjie
 * @Date 2021/9/23 09:58
 */
@FeignClient(value = "shopweb-check")
public interface CheckProblemsApi {

    /**
     * 删除门店时，删除门店对应的代办单 以及其对应的结果数据
     * @param enterpriseId 企业id
     * @param deptId 门店id
     * @return
     */
    @PostMapping("/shopweb-check/problem/deleteProblemByDeptId")
    BaseResult deleteProblemByDeptId(@RequestParam(value = "enterpriseId")Integer enterpriseId, @RequestParam(value = "deptId")Integer deptId);

    @GetMapping("/shopweb-check/problem/getProblemById")
    BaseResult<CheckProblemsVo> getProblemById(Integer id);

    @GetMapping("/shopweb-check/problem/getProblemAILogByLogId")
    BaseResult<CheckProblemAiLogVo> getProblemAILogByLogId(Integer logId);

    @GetMapping("/shopweb-check/holdingPeople/getHoldingPeopleRoleIdsByDbViewShopId")
    BaseResult<List<Integer>> getHoldingPeopleRoleIdsByDbViewShopId(Integer dbViewShopId);

    @PostMapping("/shopweb-check/problem/problemInfoOfHomePage")
    R<Map<String, Object>> problemInfoOfHomePage(@RequestBody ProblemInfoOfHomePageSearchInfo info);

    /**
     * 临时的
     * @param problemId
     * @param content
     * @param videoAndImgAttachStr
     * @param temps
     * @param aiType
     * @param reasonType
     * @param aiReasonDesc
     * @param modelId
     * @param skipAiCheck
     * @param token
     * @return
     */
    @Deprecated
    @PostMapping("/shopweb-check/claimReform/reform")
    R reform(@RequestParam(value = "problemId") Integer problemId,
                    @RequestParam(value = "content",required = false)String content,
                    @RequestParam(value = "videoAndImgAttachStr",required = false)String videoAndImgAttachStr,
                    @RequestParam(value = "temps",required = false) MultipartFile[] temps,
                    @RequestParam(value = "aiType",required = false)String aiType,
                    @RequestParam(value = "reasonType",required = false)String reasonType,
                    @RequestParam(value = "aiReasonDesc",required = false)String aiReasonDesc,
                    @RequestParam(value = "modelId",required = false) Integer modelId,
                    @RequestParam(value = "skipAiCheck",required = false)Boolean skipAiCheck,
                    @RequestParam(value = "bodyToken",required = false)String token
    );
    @Deprecated

    @PostMapping("/shopweb-check/claimReform/claim")
    R claim(@RequestParam(value = "problemId") Integer problemId,
            @RequestParam(value = "content",required = false)String content,
            @RequestParam(value = "videoAndImgAttachStr",required = false)String videoAndImgAttachStr,
            @RequestParam(value = "bodyToken")String token
    );
    @PostMapping("/shopweb-check/dbviewshop/getDbViewShopStandard")
    R standard(@RequestParam(value = "problemId") Integer problemId,
               @RequestParam(value = "bodyToken")String token);



    @PostMapping("/shopweb-check/problem/saveToProblemForAi")
    R saveToProblemDt(@RequestBody CreateProblemDo createProblemDo);

    @PostMapping("/shopweb-check/problem/getAiRectIndex")
    R<List<AiRectVo>> getAiRectIndex(@RequestBody AiRectParam param);
}