package com.ovopark.check.problem;

import com.ovopark.pojo.UserPojo;
import lombok.Data;
import lombok.ToString;
import org.springframework.web.multipart.MultipartFile;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
@ToString
public class CreateProblemDo implements Serializable {
    private static final long serialVersionUID = -1L;

    //创建人
    private Integer userId;

    private String curPicId;
    /**
     * 问题名称（问题门店名称）
     */
    private String problemName;
    /**
     * 点检项ID
     */
    private Integer problemClassifyId;

    private String problemClassifyName;
    /**
     * 问题处理人ID
     */
    private String dealUserIds;
    private String dealUserNames;
    /**
     * 门店标识
     */
    private String shopId;
    /**
     * 到期时间
     */
    private String endTime;
    /**
     * 问题来源 1点检 2摇一摇 3图片抓拍 4手动创建 5在线考评 6快拍 7告警 8现场巡店 9远程巡店 10抓拍比对 11 实时监控
     */
    private Integer sourceType;
    /**
     * 设备ID
     */
    private String deviceId;
    /**
     * 门店ID
     */
    private Integer deptId;
    /**
     * 描述
     */
    private String description;
    /**
     * 抄送人ID（多个用逗号隔开）
     */
    private String copyUserIds;//
    private String copyUserNames;
    /**
     * 细则（多个用逗号隔开）
     */
    private String detailedRuleIds;
    /**
     * 模板ID
     */
    private Integer templateId;
    /**
     * 问题的小视频或图片的 json字符串
     */
    private String videoAndImgAttachStr;
    /**
     * oss 图片url
     */
    private String imgUrlOnOss;
    /**
     * 图片id
     */
    private Integer imgIdOnOss;
    private String remark;
   /*
    是否抄送全部
    */
    private Integer isAtAll = 0;
    /**
     * 告警装备ID
     */
    private Integer id;
    /**
     * 场景ID
     */
    private Integer presetId;
    /**
     * 图片上传base64方式
     */
    private String imgUrlsStr;
    /**
     * 录像时间
     */
    private String videoTime;
    /**
     * 复检人
     */
    private Integer reviewerId;

    /***
     * 需要设备上传视频到 oss
     */
    private Integer isUploadVideo;

    /**
     * 问题 录像开始时间
     */
    private String startTimeOfVideo;

    /**
     * 问题 录像结束时间
     */
    private String endTimeOfVideo;

    /**
     * AI识别log ID
     */
    private Long logId;
    //2024-03-26 追加 （板端用）
    private String logTime;

    private List<LogBo> logs;
    /**
     *任务id
     */
    private Integer checktaskId;
    //整改人列表
    private List<UserPojo> reformers;
    private MultipartFile[] temps;

    //企业id
    private Integer groupId;
    /**
     * oss 图片url
     */
    private List<String> picUrls;
    //触发待办单时间点
    private Date dateFromDt;
    //小鸟探店会传
    private Integer historyId;
    /**
     * 发现问题描述（AI）
     */
    private String message;

    //附件
    private String attachment;

    private Integer timeSize;
    private Integer timeUnit;
    private Double score;
    //选择题（小鸟）
    private Option option;
    // AI提醒
    private AIRemind remind;

}
