package com.ovopark.api;

import com.ovopark.check.Vo.CaptureTaskVo;
import com.ovopark.pojo.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "shopweb-check")
public interface CaptureTaskApi {
    
    @GetMapping("/shopweb-check/capture-task/getById")
    BaseResult<CaptureTaskVo> getById(@RequestParam("id") Integer id);

    @GetMapping("/shopweb-check/captureTaskInspItem/getInspItemByCaptureTaskId")
    BaseResult<List<Integer>> getInspItemByCaptureTaskId(@RequestParam("id") Integer id);
}
