package com.ovopark.check.vos;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author Donily
 * @date 2022-07-06 16:11:11
 * @description 部门节点分布数据
 */
@Data
@Accessors(chain = true)
public class DepNodeDistributionVo implements Serializable {
    private static final long serialVersionUID = 1786402504745531897L;

    /**
     * 是否是数据汇总行
     */
    private Boolean dataSummaryLine = false;

    //S_id 表示门店  O_id 表示组织架构  T_id 表示标签
    private String depNode;

    private String name;
    /**
     * 区域经理或者督导下的门店集合
     */
    private List<Integer> depIds;

    private List<IntervalVo> intervals;

    /**
     * 得分率按类型分组
     */
    private List<SimpleIndicatorDataBo> scoreRateGroupBySourceType;
    /**
     * 得分率按角色分组
     */
    private List<SimpleIndicatorDataBo> scoreRateGroupByRole;

    private Integer storeCheckedNum;

    private BigDecimal indicatorData;
    /**
     * 门店分档xxx门店数量、xxx门店比例
     */
    private List<RankingDepartmentGearVo> rankingDepartmentGearVos;



}
