package com.ovopark.api;

import com.ovopark.check.R;
import com.ovopark.check.Vo.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author 潘思凡
 * @since 2022/11/25 11:05
 */
@FeignClient(value = "shopweb-check")
public interface PresetNameApi {
    @GetMapping("/shopweb-check/internalOpen/privilegedPresetnames")
    R<List<PrivilegedPresetNameVo>> getPrivilegedPresetnames(@RequestParam("enterpriseId") Integer enterpriseId, @RequestParam("userId") Integer userId);

    /**
     * 根据场景id获取此场景在门店场景配置中设置为守望位的设备id
     *
     * @param id 场景id
     * @return 设备id集合
     */
    @PostMapping("/shopweb-check/preset/getDeviceIdListByPresetId")
    R<List<Integer>> getDeviceIdListByPresetId(@RequestParam("id") java.lang.Integer id);

    /**
     * 根据设备id集合获取每台设备配置的守望场景id和名称
     *
     * @param param 设备信息
     * @return 守望场景id和名称
     */
    @PostMapping("/shopweb-check/preset/getPresetListByDeviceId")
    R<List<PresetNameDeviceInfo>> getPresetListByDeviceId(@RequestBody DeviceReqParam param);

    /**
     * 查询所有有权限门店绑定了预置位的场景名称
     * @param enterpriseId
     * @param userId
     * @param name
     * @return
     */
    @PostMapping("/shopweb-check/internalOpen/getInUsePresetNames")
    R<List<PrivilegedPresetNameVo>> getInUsePresetNames(@RequestBody SceneSearchInfo sceneSearchInfo);

    /**
     * @Description: 根据场景ID获取场景关联的点检项
     * @param: param
     * @return com.ovopark.check.R<java.util.List<com.ovopark.check.Vo.PresetNamesVo>>
     * @author yangJie
     * @date 2025/6/3 0003 17:08:33
    */
    @PostMapping("/shopweb-check/preset/getInspectionItemBySceneId")
    R<List<SimplePresetNamesVo>> getInspectionItemBySceneId(@RequestBody SceneSearchVo param);
}
