package com.ovopark.check.Vo;

import lombok.Data;

/**
 * @author 潘思凡
 * @since 2023/6/6 16:35
 */
@Data
public class CheckTemplateVo {
   private Integer id;

   private String name;
   /**
    * 0:场景常用模板
    * 1:点检项常用模板
    */
   private Integer sourceType;

   private Integer enterpriseId;


   /**
    * 模板是否设置权限 0 否 1是
    */
   private Integer isSetPrivilege;

   /**
    * 排序
    */
   private Integer orderer;

   /**
    * 模板类型 0-巡店模板 1-门店自检模板
    */
   @Deprecated
   private Integer isIntrospectionOpen;

   /**
    * 是否为现场巡店模板
    */
   private Boolean onSiteTemplate = true;

   /**
    * 是否为远程巡店模板
    */
   private Boolean remoteTemplate = true;
   /**
    * 是否为门店自检模板
    */
   private Boolean storeSelfInspectionTemplate = false;

   /**
    * 门店自检评分规则 1：自检人评分 2：审核人评分
    */
   private Integer introspectionScoreRule;

   /**
    * 分值计算模式  1.累加模式,2.总分累减模式
    */
   private Integer scoreType;

   /**
    * 模板版本,每次修改递增
    */
   private Integer version;

   private Integer deleted;
   /**
    * 模板增加开启/关闭功能，默认开启为1，关闭为0
    */
   private Integer isOpen;
   /**
    * 组织架构或者具体门店，以,分割，可以多个
    */
   private String visibleOrganizes;
   /**
    * 巡店时默认全部合格，开启为1，默认关闭为0
    */
   private Integer isQualified;

   /**
    * 是否智能模板
    */
   private Boolean isSmart;

   /**
    * 排好序的点检项id,业务都按这个顺序
    */
   private String sortedInspectionIds;

   /**
    * 模板巡店类型：“onSiteTemplate, remoteTemplate, storeSelfInspectionTemplate”
    */
   private String templateType;
}
