package com.ovopark.api;


import com.ovopark.check.R;
import com.ovopark.check.Vo.*;
import com.ovopark.pojo.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * shopweb项目调用
 * 预置位 api
 * @author wdz
 * @Date 2020/3/6 13:56
 * @Description:
 */

@FeignClient(value = "shopweb-check")
public interface SceneApi {


    /**
     * 根据设备id和预置位编号获取门店场景配置
     *
     * @param deviceId 设备id
     * @param presetNo 预置位编号
     * @return
     */
    @PostMapping("/shopweb-check/scene/getSceneByDevicePreset")
    BaseResult<SceneVo> getSceneByDevicePreset(@RequestParam(value = "deviceId") Integer deviceId, @RequestParam(value = "presetNo") Integer presetNo);

    /**
     * 根据id获取记录
     *
     * @param id
     * @return
     */
    @PostMapping("/shopweb-check/scene/findById")
    BaseResult<SceneVo> findById(@RequestParam(value = "id") Integer id);

    /**
     * 根据企业id和门店id集合批量设置门店场景为人工上传
     *
     * @param deptIds      门店id
     * @param enterpriseId 企业id
     * @return
     */
    @PostMapping("/shopweb-check/scene/saveExtendedSceneByDeptIds")
    BaseResult saveExtendedSceneByDeptIds(@RequestParam("enterpriseId") Integer enterpriseId, @RequestParam("deptIds") List<Integer> deptIds);

    /**
     * 根据门店id删除门店下的场景
     *
     * @param depId 门店id
     * @return
     */
    @PostMapping("/shopweb-check/scene/deleteSceneByDeptId")
    BaseResult deleteSceneByDeptId(@RequestParam("depId") Integer depId);


    /**
     * 根据场景模板id获取已配置的门店id
     *
     * @param id
     * @return
     */
    @GetMapping("/shopweb-check/scene/getDeptIdsBySceneId")
    BaseResult getDeptIdsBySceneId(@RequestParam("id") Integer id);


    /**
     * 设备退网接口
     *
     * @param deviceId 门店id
     * @return
     */
    @PostMapping("/shopweb-check/scene/removeSceneByDeviceId")
    BaseResult removeSceneByDeviceId(@RequestParam("deviceId") Integer deviceId);


    @PostMapping("/shopweb-check/internalOpen/setWatchingScene")
    BaseResult setWatchingScene(@RequestParam("sceneId") Integer sceneId, @RequestParam("status") Integer status);

    @PostMapping("/shopweb-check/internalOpen/revertScenes")
    BaseResult revertScenes(@RequestParam("deptId") Integer deptId, @RequestParam("deviceId") Integer deviceId);

    @PostMapping("/shopweb-check/internalOpen/removeDeviceWatchingScene")
    BaseResult removeDeviceWatchingScene(@RequestParam("deviceId") Integer deviceId);

    /**
     * 根据ids获取记录
     *
     * @param ids
     * @return
     */
    @PostMapping("/shopweb-check/scene/findByIds")
    BaseResult<List<SceneVo>> findByIds(@RequestBody List<Integer> ids);

    @PostMapping("/shopweb-check/scene/getUnFullConfigDeptIds")
    BaseResult<List<Map<String,Object>>> getUnFullConfigDeptIds(@RequestParam("enterpriseId") Integer enterpriseId);

    @PostMapping("/shopweb-check/scene/getSceneByPage")
    BaseResult<List<SceneNameVO>> getSceneByPage(@RequestBody SceneForAiDTO dto);

    @PostMapping("/shopweb-check/scene/getScene")
    BaseResult<SceneVo> getScene(@RequestBody SceneForAiDTO dto);

    @GetMapping("/shopweb-check/scene/findList")
    R<QueryResult<SceneVo>> findList(@RequestParam(value = "deviceId") Integer deviceId,
                                     @RequestParam(value = "depId") Integer depId,
                                     @RequestParam(value = "pageNumber") Integer pageNumber,
                                     @RequestParam(value = "pageSize") Integer pageSize);

    @PostMapping("/shopweb-check/scene/getSceneByCondition")
    List<SceneVo> getSceneByCondition(@RequestBody SceneSearchInfo dto);

    @PostMapping(value = "/shopweb-check/scene/getSceneNameByDeptIdAndDeviceIdAndNo")
    R<String> getSceneNameByDeptIdAndDeviceIdAndNo(@RequestParam("enterpriseId") Integer enterpriseId,
                                                   @RequestParam("deptId") Integer deptId,
                                                   @RequestParam("deviceId") Integer deviceId,
                                                   @RequestParam("presetNo") Integer presetNo);

    @PostMapping(value = "/shopweb-check/scene/getAllSceneConfig")
    R<List<SceneVo>> getAllSceneConfig();
}
