package com.ovopark.api;

import com.ovopark.check.Vo.InspectionItemSearchVo;
import com.ovopark.check.Vo.InspectionItemVo;
import com.ovopark.pojo.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import java.util.List;

/**
 * @author 潘思凡
 * @since 2022/3/1 11:58 上午
 */
@FeignClient(value = "shopweb-check")
public interface InspectionItemApi {

    @PostMapping("/shopweb-check/internalOpen/resetInspectionItemExpireInterval")
    BaseResult resetInspectionItemExpireInterval(@RequestParam("groupId") Integer groupId,
                                                 @RequestParam("interval") Integer interval);

    @GetMapping("/shopweb-check/dbviewshop/getInspectionItemById")
    BaseResult<InspectionItemVo> getInspectionItemById(Integer id);

    @PostMapping("/shopweb-check/dbviewshop/getInspectionItemByIdList")
    BaseResult<List<InspectionItemVo>> getInspectionItemByIdList(@RequestBody InspectionItemSearchVo searchInfo);



}
