package com.ovopark.check.Vo;

import lombok.Data;

import java.math.BigDecimal;

@Data
public class TaskResultVo {

    private static final long serialVersionUID = 1L;
    /*
     * 任务
     */
    private Integer taskId;
    /*
     * 总数
     */
    private Integer totalNum =0;
    /*
     * 合格数
     */
    private Integer qualifiedNum=0;
    /*
     * 不合格数
     */
    private Integer unqualifiedNum=0;

    /*
     * 不适用数
     */
    private Integer inapplicableNum=0;

    /*
     * 检查项合格率
     */
    private BigDecimal qualifiedRate;


    public BigDecimal getQualifiedRate() {
        if (qualifiedNum == null || totalNum == null || totalNum == 0) return null;
        BigDecimal rate =
                new BigDecimal(qualifiedNum + "")
                        .multiply(new BigDecimal("100"))
                        .divide(new BigDecimal(totalNum + ""), 2, BigDecimal.ROUND_HALF_UP);
        return rate;
    }
}
