package com.ovopark.check.core;

import com.ovopark.check.common.Command;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author 潘思凡
 * @since 2022/7/8 15:35
 */
@Data
@Accessors(chain = true)
public class SyncCheckTaskCmd extends Command {
    /**
     * 任务id
      */
    private Integer id;
    /**
     * 是否审核流程(审核流程不直接修改巡店结果,只修改缓存,直到审核提交)
     */
    private Boolean isReview = false;
    private Boolean revokeAiReview = false;
    /**
     * 审核层级
     */
    private Integer level;

    private final List<SingleSyncCheckTaskCmd> multiCmd = new ArrayList<>();

    /**
     * 单个record
     */
    @Data
    public static class SingleSyncCheckTaskCmd {
        private Integer inspectionItemId;
        @Deprecated
        /**
         * 不合格的细则
         */
        private List<Integer> unqualifiedDetailRuleIds;
        private List<SubItemCmd> subItemStatusList;
        private String description;
        private Integer status;
        private Double score;
        private Integer times;
        private String replayTime;
        private Double money;
        private Integer moneyTimes;
        private List<Attach> attaches;
        //整改信息
        private String reformInfoStr;
        private Integer version;
        /**
         *  规则扣分手填
         *  <a href='http://jira-inc.ovopark.com:8080/browse/WDZ-44145'>需求jira</a>
         */
        private Double ruleRedudence;
        private Double rewardScore;
        private Double optionScore;
        private Integer optionId;
        //奖惩抄送人
        private List<Integer> rpCcUserIds;
        //联动扣分
        private LinkedScoreCmd linked;

        public List<SubItemCmd> getSubItemStatusList() {
            if (CollectionUtils.isEmpty(unqualifiedDetailRuleIds)){
                return subItemStatusList;
            }
            return unqualifiedDetailRuleIds.stream().map(id -> {
                SubItemCmd subItemCmd = new SubItemCmd();
                subItemCmd.setId(id);
                subItemCmd.setStatus(0);
                return subItemCmd;
            }).collect(Collectors.toList());
        }
    }
    @Data
    public static class SubItemCmd {
        private Integer id;
        private Integer status;
    }
    @Data
    public static class Attach{

        public static final Integer ATTACH_TYPE_IMAGE = 0;
        public static final int ATTACH_TYPE_VIDEO = 1;


        private String url;
        private String thumbUrl;
        private Long size;
        private Integer attachType;
        private Integer deviceId;
        private String snapshotTime;
        private Integer videoTime;
        private String name;
        private Integer deptId;
        private String startTime;
        private String endTime;
        private Long videoId;
        private Integer id;
        private String downloadReq;
        public String getName(){
            if (StringUtils.isEmpty(url) || !url.contains("/")){
                return "";
            }
            return url.substring(url.lastIndexOf("/") + 1);
        }

        public boolean isImage(){
            return Objects.equals(ATTACH_TYPE_IMAGE,attachType);
        }
        public boolean isVideo(){
            return Objects.equals(ATTACH_TYPE_VIDEO,attachType);
        }
    }
    @Data
    public static class LinkedScoreCmd{
        private List<Integer> userIds;
        private Double score;

        public List<Integer> getUserIds(){
            if (null == userIds){
                return null;
            }
            return userIds.stream().distinct().collect(Collectors.toList());
        }
    }
}
