package com.ovopark.check;

import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;
@Slf4j
public class R<T> {

	public static String p;

	// 通用的状态码
	public abstract class CommonCode {
		public static final String SUCCESS = "0"; // 获取数据成功状态码
		public static final String ERROR = "1";	//	请求失败

		public static final String IS_EXIST = "10000"; // 数据已存在
		public static final String INVALID_TOKEN = "20000"; // token有误
		public static final String PARAM_ERROR = "20001"; // 参数传递错误状态码
		public static final String NO_DATA = "20002"; //没有数据
		public static final String RESULT_DUPLICATE = "20003";//重复提交
		public static final String DELETE_FAILE = "20004";//删除失败
		public static final String POINT_EXCEED_LIMIT = "20005"; //预置位已用完
		public static final String NO_PRIVILEGE = "20006"; //没有权限
		public static final String NO_SUPPORT = "20007"; //不支持
		public static final String TEMPLATE_DUPLICATE = "20008";
		public static final String TIME_OVER_ERROR = "50001"; // 任务时间无效
		public static final String REPEAT_INTERVAL_ERROR = "50002"; // 执行间隔不能超过24h
		public static final String NO_SUMMARY = "20009";  //没有总结
		public static final String NO_REMARK = "20010"; //没有评论
		public static final String PROCESS_EXPIRED = "20011"; //申诉流程已结束
		public static final String CHECK_EXPIRED = "20022";
		public static final String NOT_COOPERATOR = "20023";
		/**
		 * 没有附录内容
		 */
		public static final String NO_APPENDIX = "20023";

		public static final String EXTERNAL_LINK_NAME_IS_EMPTY = "83001"; //外部链接名称为空
		public static final String EXTERNAL_LINK_URL_IS_EMPTY = "83002"; //外部链接url为空
		public static final String EXTERNAL_LINK_COUNT_LIMIT = "83003"; //外部链接数量超出限制
		public static final String STANDARD_CONTENT_INVALID = "83004"; //content传了standardType没有的类型内容
		public static final String PARAM_VALID_ERROR = "80001"; //参数格式校验失败
		public static final String CREATE_LIVE_TASK_ERROR = "90001"; //创建巡店任务失败
		public static final String EXIST_CHECK_TASK = "90002"; //点检项下面存在点检任务 删除失败
		public static final String DB_SHOP_VIEW = "90003"; // 点检项配置有效期大于企业配置的有效期,默认拿企业配置的有效期
		public static final String NO_CARBONCOPYRECIPIENTS = "81001"; //巡店提交没有抄送人
		public static final String ROLE_CHECKER_REFORMER_REPEAT = "81002"; //整改人与复检人角色重复
		public static final String ROLE_CHECKER_REFORMER_NOT_EXIST = "81003"; //复检人角色或者抄送人角色不存在
		public static final String DEPT_EXPIRE = "81004"; //门店已关闭
		public static final String NO_ENTERPRISECONFIG_FOR_CHECKINFORMATIONREPORT = "81005"; // 个性化配置-门店报备未配置
		public static final String NO_USER_WAS_GRANT_FOR_CHECKINFORMATIONREPORT = "81006"; // 此角色下有此门店权限的人不存在
		public static final String DEPARTMENT_NOT_EXIST = "81007"; // 门店不存在
		public static final String COMMENTS_OF_COMMENTS_CANNOT_BE_COMMENTED = "81008"; // 评论的评论不能进行评论
		public static final String COMMENT_CANNOT_BE_NULL = "81009"; // 评论不能为空
		public static final String OVER_FIVE_INPROGRESS = "81010"; //大于5个进行中
		public static final String NEED_STUDY_METERIAL = "81011"; //请去app学习素材后提交
		public static final String NEED_STUDY_SUBJECT = "81012"; //请去app学习课程后提交
		public static final String VIEWSHOP_DELETED = "81013"; //点检项已经删除
		public static final String COMMENT_DENY = "81014"; //禁止评论
		public static final String HANDLE_DENY = "81015"; //问题过期，禁止处理
		public static final String NOT_ASSIGN = "81016"; //未指定审核人员
		public static final String NO_DEVICE = "81017"; //暂无设备
		public static final String SCENE_NO_DEVICE = "81018"; //场景未绑定设备

		public static final String DEPT_CLOSED = "81019"; //门店不在营业时间
		public static final String FORBID_BEYOND_SCOPE = "81020"; //禁止允许超出门店范围
		public static final String CHECKED = "81021"; //已审核
		public static final String PLAN_TASK = "81022"; //计划巡店
		public static final String FORBID_REVIEWER_REFUSE = "81023"; //禁止审核人驳回
		public static final String REVIEWER_SIGN_REQUIRED = "82023"; // 审核人签名必填
		public static final String RENAME_NOT_PERMITTED_FOR_NONSUPADMIN = "83023"; // 非超管用户禁止重命名通用筛选条件
		public static final String DELETE_NOT_PERMITTED_FOR_NONSUPADMIN = "83024"; // 非超管用户禁止删除通用筛选条件
		public static final String NONSUPADMIN_CANNOT_CHANGE_PERMISSION = "83025"; // 非超管用户禁止修改权限
		public static final String VIEW_CONFIG_NOT_EXIST = "83026"; // 筛选条件不存在
		// 门店过期
		public static final String DEPARTMENT_OVERDUE = "81023";
		// 巡店总时长/开启拍照签退 要求规则：最多可以新增10条规则
		public static final String YOU_CAN_ONLY_ADD_UP_TO_10_RULES = "82000";
		// 巡店最低时长
		public static final String CHECK_TOTAL_TIME_INSUFFICIENT = "82001";
		public static final String REMOTE_CHECK_TOTAL_TIME_INSUFFICIENT = "82002";
		public static final String STORE_CHECK_TOTAL_TIME_INSUFFICIENT = "82003";
		// 必须上传图片
		public static final String MUST_UPLOAD_PICTURES = "82004";
		// 已存在相同规则的巡店报告订阅
		public static final String EXIST_REPORT_SUBSCRIPTION = "82005";
		// 名称重复,请修改
		public static final String EXIST_REPORT_SUBSCRIPTION_NAME = "82006";

		//  巡店报告订阅，所选的组织架构不是JSON格式
		public static final String REPORT_SUBSCRIPTION_ORGANIZE_JSON_PARSE_ERROR = "82007";
		//  巡店报告订阅，所选的组织架构不是JSON格式
		public static final String REPORT_SUBSCRIPTION_ORGANIZE_NOT_JSON = "82008";

		public static final String NOT_CURRENT_LEVEL_REVIEWER = "82009"; //当前操作人不是当前层级审核人
		public static final String STATUS_ERROR = "82010"; //待办单状态不正确 不可此操作
		public static final String CHECK_INFORMATION_REPORT_ACCEPT_ID_IS_NULL = "82011"; //门店报备暂无受理人
		public static final String CHECK_INFORMATION_REPORT_IS_ACCEPTED = "82012"; // 门店报备已被受理
		public static final String NOT_BELONGING_TO_ENTERPRISE = "82013"; // 处理人并非本企业员工
		public static final String UNDER_APPROVAL = "90000";//已有延期申请审批中，不可再次发起
		public static final String CREATE_EXTEND_ERROR = "90001"; //发起延期失败
		public static final String TIME_ERROR_1 = "90002";//当前日期大于当前到期日不可延长
		public static final String TIME_ERROR_2 = "90003";//变更到期日小于当期日期，该延期审批已失效
		public static final String TIME_ERROR_3 = "90004";//变更到期日小于当期日期，该延期审批已失效
		public static final String CHECKER_ERROR = "90005";//变更到期日小于当期日期，该延期审批已失效
		public static final String LIVE_CHECK_TASK_INVALID = "90991";
		public static final String TASK_NOT_EXIST = "90006";

		public static final String NEED_STUDY_YXT_PROJECT = "81014"; //请去app学习云学堂项目后提交
		// 未选中或者不适用不能分享
		public static final String LIVE_CHECK_TASK_SHARED_ERROR = "90992";
		// 点检任务子任务超过30天，已失效，不能提交
		public static final String CHECK_TASK_RECORD_STATE_LOSE_EFFICACY = "90993";
		// 设备预置位编号已经被使用，请重新选择设备
		public static final String PRESET_NO_HAVE_USED = "90994";
		// 暂无场景
		public static final String NO_PRESET = "90995";
		// 点检任务子任务场景已经提交
		public static final String CHECK_TASK_RECORD_PRESET_STATE_FINISHED = "90996";
		// 点检任务子任务点检人不匹配
		public static final String CHECK_TASK_RECORD_USER_NOT_MATCH = "90997";
		// 该场景已经是守望场景
		public static final String PRESET_IS_WATCH = "90998";
		// 该场景非守望场景
		public static final String PRESET_NOT_WATCH = "90999";
		// 场景下无设备，无法配置守望位
		public static final String PRESET_NO_DEVICE = "91000";
		// 重复的门店分档
		public static final String DUPLICATE_STORE_GEAR = "91001";
		// 用户签到记录
		public static final String NEED_USER_SIGN_IN = "91002";
		// 导入错误
		public static final String IMPORT_ERROR = "91003";
		// 文件大小不可超过10M
		public static final String FILE_SIZE_ERROR  = "91004";
		// 仅支持上传excel格式文件
		public static final String FILE_TYPE_ERROR  = "91005";
		// 图片的url为空
		public static final String URL_IS_NULL = "91006";
		// 失效任务
		public static final String INVALID_TASK = "91007";
		// 存在未完成
		public static final String UNCOMPLETE_PROBLEM = "91008";
		public static final String EMPTY_INSP_ITEM_LIST = "91009";
		public static final String VIDEO_NOT_FINISH = "91012";
		// 门店下存在未完成的计划巡店任务，不允许创建临时巡店
		public static final String EXIST_UNDONE_PLAN_PROHIBIT_NORMAL = "91010";
		// 请勿重复操作
		public static final String NOT_REPEAT_OPERATIONS = "91011";
		// 等待巡店中的协同成员全部提交
		public static final String WAIT_FOR_ALL_CO_INSPECTORS_TO_SUBMITTED = "91012";
		// 可见门店长度过长
		public static final String VISIBLE_ORGANIZES_TOO_LONG = "91013";
		public static final String QUICK_PHRASES_CLASSIFICATION_EXISTS = "91014";

		public static final String CHECK_TYPE_ERROR = "91015";
		// 其他门店下存在未提交的巡店任务（现场和门店自检），不允许创建巡店任务（现场和门店自检）
		public static final String EXIST_UNCOMMIT_PROHIBIT_CREATE = "91016";
		public static final String CONFIGS_NOT_FOUND = "91017";
		public static final String CONTEXT_USER_NOT_FOUND = "91018";
		// 编码重复
		public static final String CODE_REPEAT = "91019";
		public static final String HISTORY_MODEL_IS_NULL = "91020";

		// 报备类型名称已存在
		public static final String CHECK_INFORMATION_TYPE_NAME_DUPLICATE = "91021";
		// 点检项编码存在,导入的点检项所属分类和已存在的点检项所属分类不一致
		public static final String CODE_EXISTS = "91022";

	}

	// 通用的消息
	public abstract class CommonMessage {
		public static final String SUCCESS = "SUCCESS"; // 获取数据成功
		public static final String ERROR = "ERROR";	//	请求失败
		public static final String IS_EXIST = "IS_EXIST";
		public static final String INVALID_TOKEN = "INVALID_TOKEN"; // token有误
		public static final String PARAM_ERROR = "PARAM_ERROR"; // 参数传递错误
		public static final String DELETE_FAILE = "DELETE_FAILE";
		public static final String TIME_OVER_ERROR = "TIME_OVER_ERROR"; // 任务永远不会被执行
		public static final String REPEAT_INTERVAL_ERROR = "can not exceed 24 hours"; // 执行间隔不能超过24h
		public static final String RESULT_NO_DATA="NO_DATA";
		public static final String RESULT_DUPLICATE = "DUPLICATE";
		public static final String RESULT_RULE_DUPLICATE = "RESULT_RULE_DUPLICATE";
		public static final String NO_PRIVILEGE = "NO_PRIVILEGE";
		public static final String NO_SUPPORT = "NO_SUPPORT";
		public static final String TEMPLATE_DUPLICATE="模板类型不统一";
		public static final String NOT_COOPERATOR="NOT_COOPERATOR";
		//预置位已用完
		public static final String POINT_EXCEED_LIMIT = "EXCEED_LIMIT";

		public static final String PARAM_VALID_ERROR = "参数格式校验失败";

		public static final String NO_SUMMARY = "NO_SUMMARY";
		public static final String TASK_NOT_EXIST = "TASK_NOT_EXIST";
		/**
		 * 没有附录内容
		 */
		public static final String NO_APPENDIX = "NO_APPENDIX";
		public static final String NO_REMARK = "NO_REMARK";

		public static final String EXTERNAL_LINK_NAME_IS_EMPTY = "外部链接名称不能为空";
		public static final String EXTERNAL_LINK_URL_IS_EMPTY = "外部链接Url不能为空或包含空格";
		public static final String EXTERNAL_LINK_COUNT_LIMIT = "外部链接数量超出限制";
		public static final String STANDARD_CONTENT_INVALID = "content传了standardType没有的类型内容";
		public static final String CREATE_LIVE_TASK_ERROR = "CREATE_LIVE_TASK_ERROR"; //创建巡店任务失败

		public static final String EXIST_CHECK_TASK = "EXIST_CHECK_TASK"; //点检项下面存在点检任务 删除失败
		public static final String NO_CARBONCOPYRECIPIENTS = "NO_CARBONCOPYRECIPIENTS"; //巡店提交没有抄送人
		public static final String ROLE_CHECKER_REFORMER_REPEAT = "ROLE_CHECKER_REFORMER_REPEAT"; //整改人与复检人角色重复
		public static final String ROLE_CHECKER_REFORMER_NOT_EXIST = "ROLE_CHECKER_REFORMER_NOT_EXIST"; //复检人角色或者抄送人角色不存在
		public static final String DEPT_EXPIRE = "DEPARTMENT_EXPIRE"; //门店已关闭
		public static final String NO_ENTERPRISECONFIG_FOR_CHECKINFORMATIONREPORT = "no EnterpriseConfig for CheckInformationReport"; // 个性化配置-门店报备未配置
		public static final String NO_USER_WAS_GRANT_FOR_CHECKINFORMATIONREPORT = "no user was grant for CheckInformationReport"; // 此角色下有此门店权限的人不存在
		public static final String DEPARTMENT_NOT_EXIST = "department not exist"; // 门店不存在
		public static final String COMMENTS_OF_COMMENTS_CANNOT_BE_COMMENTED = "comments of comments cannot be commented"; // 评论的评论不能进行评论
		public static final String COMMENT_CANNOT_BE_NULL = "comment cannot be null"; // 评论不能为空
		public static final String OVER_FIVE_INPROGRESS = "over five inprosess";
		public static final String CHECK_EXPIRED = "CHECK_EXPIRED";
		public static final String NEED_STUDY_METERIAL = "NEED_STUDY_MATERIAL"; //请去app学习素材后提交
		public static final String NEED_STUDY_SUBJECT = "NEED_STUDY_SUBJECT"; //请去app学习课程后提交
		public static final String VIEWSHOP_DELETED = "VIEWSHOP_DELETED"; //点检项已删除
		public static final String COMMENT_DENY = "COMMENT_DENY"; //禁止评论
		public static final String HANDLE_DENY = "HANDLE_DENY"; //问题过期，禁止处理
		public static final String NOT_ASSIGN = "NOT_ASSIGN"; //未指定审核人员
		public static final String NO_DEVICE = "NO_DEVICE"; //暂无设备
		public static final String SCENE_NO_DEVICE = "SCENE_NO_DEVICE"; //场景未绑定设备
		public static final String URL_IS_NULL = "URL_IS_NULL"; //图片的url为空
		public static final String FORBID_BEYOND_SCOPE = "FORBID_BEYOND_SCOPE"; //禁止允许超出门店范围
		public static final String DEPT_CLOSED = "DEPT_CLOSED"; //门店不在营业时间
		public static final String CHECKED = "CHECKED"; //已审核
		public static final String PLAN_TASK = "PLAN_TASK"; //计划巡店
		public static final String FORBID_REVIEWER_REFUSE = "FORBID_REVIEWER_REFUSE"; //禁止审核人驳回
		public static final String REVIEWER_SIGN_REQUIRED = "reviewerSignUrl is required"; // 审核人签名必填
		public static final String RENAME_NOT_PERMITTED_FOR_NONSUPADMIN = "nonsuperadmin cannot rename general filter condition";
		public static final String DELETE_NOT_PERMITTED_FOR_NONSUPADMIN = "nonsuperadmin cannot delete general filter condition";
		public static final String NONSUPADMIN_CANNOT_CHANGE_PERMISSION = "nonsuperadmin cannot change permission";
		public static final String VIEW_CONFIG_NOT_EXIST = "filter condition does not exist";
		// 门店过期
		public static final String DEPARTMENT_OVERDUE = "DEPARTMENT_OVERDUE";

		// 巡店总时长/开启拍照签退 要求规则：最多可以新增10条规则
		public static final String YOU_CAN_ONLY_ADD_UP_TO_10_RULES = "YOU_CAN_ONLY_ADD_UP_TO_10_RULES";
		// 巡店最低时长
		public static final String CHECK_TOTAL_TIME_INSUFFICIENT = "CHECK_TOTAL_TIME_INSUFFICIENT";
		// 远程巡店最低时长
		public static final String REMOTE_CHECK_TOTAL_TIME_INSUFFICIENT = "REMOTE_CHECK_TOTAL_TIME_INSUFFICIENT";
		public static final String STORE_CHECK_TOTAL_TIME_INSUFFICIENT = "STORE_CHECK_TOTAL_TIME_INSUFFICIENT";
		public static final String PROCESS_EXPIRED = "PROCESS_EXPIRED"; //申诉流程已结束
		// 必须上传图片
		public static final String MUST_UPLOAD_PICTURES = "MUST_UPLOAD_PICTURES";
		// 已存在相同规则的巡店报告订阅
		public static final String EXIST_REPORT_SUBSCRIPTION = "EXIST_REPORT_SUBSCRIPTION";
		// 名称重复,请修改
		public static final String EXIST_REPORT_SUBSCRIPTION_NAME = "EXIST_REPORT_SUBSCRIPTION_NAME";

		//  巡店报告订阅，所选的组织架构不是JSON格式
		public static final String REPORT_SUBSCRIPTION_ORGANIZE_JSON_PARSE_ERROR = "REPORT_SUBSCRIPTION_ORGANIZE_JSON_PARSE_ERROR";

		// 巡店报告订阅，所选的组织架构不是JSON格式
		public static final String REPORT_SUBSCRIPTION_ORGANIZE_NOT_JSON = "REPORT_SUBSCRIPTION_ORGANIZE_NOT_JSON";
		public static final String NOT_CURRENT_LEVEL_REVIEWER = "NOT_CURRENT_LEVEL_REVIEWER"; //当前操作人不是当前层级审核人

		public static final String STATUS_ERROR = "STATUS_ERROR"; //待办单状态不正确 不可此操作

		public static final String CHECK_INFORMATION_REPORT_ACCEPT_ID_IS_NULL = "CHECK_INFORMATION_REPORT_ACCEPT_ID_IS_NULL"; //门店报备暂无受理人
		public static final String CHECK_INFORMATION_REPORT_IS_ACCEPTED = "CHECK_INFORMATION_REPORT_IS_ACCEPTED"; // 门店报备已被受理
		public static final String NOT_BELONGING_TO_ENTERPRISE = "NOT_BELONGING_TO_ENTERPRISE"; // 处理人并非本企业员工
		public static final String NEED_STUDY_YXT_PROJECT = "NEED_STUDY_YXT_PROJECT"; //请去app学习云学堂项目后提交
		public static final String UNDER_APPROVAL = "UNDER_APPROVAL";//已有延期申请审批中，不可再次发起
		public static final String CREATE_EXTEND_ERROR = "CREATE_EXTEND_ERROR"; //发起延期失败
		public static final String TIME_ERROR_1 = "TIME_ERROR_1";//当前日期大于当前到期日不可延长
		public static final String TIME_ERROR_2 = "TIME_ERROR_2";//变更到期日小于当期日期，该延期审批已失效
		public static final String TIME_ERROR_3 = "TIME_ERROR_3";//变更到期日-待办单创建日期<30天
		// 未选中或者不适用不能分享
		public static final String LIVE_CHECK_TASK_SHARED_ERROR = "NOT SELECTED OR NOT APPLICABLE,UNABLE TO SHARE";
		// 点检任务子任务超过30天，已失效，不能提交
		public static final String CHECK_TASK_RECORD_STATE_LOSE_EFFICACY = "CHECK_TASK_RECORD_STATE_LOSE_EFFICACY";
		//审核人不能为申请人，请重新选择
		public static final String CHECKER_ERROR ="CHECKER_ERROR";

		// 设备预置位编号已经被使用，请重新选择设备
		public static final String PRESET_NO_HAVE_USED = "PRESET_NO_HAVE_USED";
		// 暂无场景
		public static final String NO_PRESET = "NO_PRESET";
		// 点检任务子任务场景已经提交
		public static final String CHECK_TASK_RECORD_PRESET_STATE_FINISHED = "CHECK_TASK_RECORD_PRESET_STATE_FINISHED";
		// 点检任务子任务点检人不匹配
		public static final String CHECK_TASK_RECORD_USER_NOT_MATCH = "CHECK_TASK_RECORD_USER_NOT_MATCH";
		// 该场景已经是守望场景
		public static final String PRESET_IS_WATCH = "PRESET_IS_WATCH";
		// 该场景非守望场景
		public static final String PRESET_NOT_WATCH = "PRESET_NO_WATCH";
		// 场景下无设备，无法配置守望位
		public static final String PRESET_NO_DEVICE = "PRESET_NO_DEVICE";
		// 重复的门店分档
		public static final String DUPLICATE_STORE_GEAR = "DUPLICATE_STORE_GEAR";
		// 用户签到记录
		public static final String NEED_USER_SIGN_IN = "NEED_USER_SIGN_IN";
		// 文件大小不可超过10M
		public static final String FILE_SIZE_ERROR  = "FILE_SIZE_ERROR";
		// 仅支持上传excel格式文件
		public static final String FILE_TYPE_ERROR  = "FILE_TYPE_ERROR";
		// 失效任务
		public static final String INVALID_TASK = "INVALID_TASK";
		// 存在未完成
		public static final String UNCOMPLETE_PROBLEM = "UNCOMPELETE_PROBLEM";
		public static final String EMPTY_INSP_ITEM_LIST = "EMPTY_INSP_ITEM_LIST";
		public static final String VIDEO_NOT_FINISH = "VIDEO_NOT_FINISH";
		// 门店下存在未完成的计划巡店任务，不允许创建临时巡店
		public static final String EXIST_UNDONE_PLAN_PROHIBIT_NORMAL = "EXIST_UNDONE_PLAN_PROHIBIT_NORMAL";
		// 其他门店下存在未提交的巡店任务（现场和门店自检），不允许创建巡店任务（现场和门店自检）
		public static final String EXIST_UNCOMMIT_PROHIBIT_CREATE = "EXIST_UNCOMMIT_PROHIBIT_CREATE";
		// 请勿重复操作
		public static final String NOT_REPEAT_OPERATIONS = "NOT_REPEAT_OPERATIONS";

		// 等待巡店中的协同成员全部提交
		public static final String WAIT_FOR_ALL_CO_INSPECTORS_TO_SUBMITTED = "Please wait for all co-inspectors to complete their submissions";
		// 可见门店长度过长
		public static final String VISIBLE_ORGANIZES_TOO_LONG = "VISIBLE_ORGANIZES_TOO_LONG";
		public static final String QUICK_PHRASES_CLASSIFICATION_EXISTS = "QUICK_PHRASES_CLASSIFICATION_EXISTS";
		public static final String CHECK_TYPE_ERROR = "not support selfCheck type";
		public static final String CONFIGS_NOT_FOUND = "CONFIGS_NOT_FOUND";
		public static final String CONTEXT_USER_NOT_FOUND = "CONTEXT_USER_NOT_FOUND";
		// 编码重复
		public static final String CODE_REPEAT = "CODE_REPEAT";
		public static final String HISTORY_MODEL_IS_NULL = "task submit history model is null";

		// 报备类型名称已存在
		public static final String CHECK_INFORMATION_TYPE_NAME_DUPLICATE = "CHECK_INFORMATION_TYPE_NAME_DUPLICATE";

		// 点检项编码存在,导入的点检项所属分类和已存在的点检项所属分类不一致
		public static final String CODE_EXISTS = "CODE_EXISTS";
	}

	public enum ResultCodeEnum {
		EMPTY_STORE("88001", "Empty store"),
		/* 不支持root用户 */
		NOT_SUPPORT_ROOT_USER("88002", "Root user is not supported"),
		/* 查询条件不合法 */
		INVALID_QUERY_CONDITION("88003", "Query condition is invalid"),
		/** 角色下没人员 */
		EMPTY_PERSON_UNDER_ROLE("80004", "Empty person under role"),
		;
		private String code;

		private String message;

		ResultCodeEnum() {
		}

		ResultCodeEnum(String code, String message) {
			this.code = code;
			this.message = message;
		}

		public String getCode() {
			return this.code;
		}

		public void setCode(String code) {
			this.code = code;
		}

		public String getMessage() {
			return this.message;
		}

		public void setMessage(String message) {
			this.message = message;
		}
	}

	public R() {}

	private Boolean isError;
	private T data;
	private String code;
	private String message;
	private String requestId;

	public Boolean getIsError() {
		return isError;
	}

	public void setIsError(Boolean isError) {
		this.isError = isError;
	}

	public T getData() {
		return data;
	}

	public void setData(T data) {
		this.data = data;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public R(Boolean isError, T data, String code, String message) {
		this.isError = isError;
		this.data = data;
		this.code = code;
		this.message = message;
	}

	public static<T> R<T> getInstance(Boolean isError, T data, String code, String message){
		return new R<T>(isError, data, code, message);
	}

	public static<T> R<T> invalidToken(){
		return getInstance(true, null, R.CommonCode.INVALID_TOKEN, R.CommonMessage.INVALID_TOKEN);
	}

	public static<T> R<T> paramError(){
		return getInstance(true, null, R.CommonCode.PARAM_ERROR, R.CommonMessage.PARAM_ERROR);
	}
	public static<T> R<T> noData(){
		return getInstance(false, null,  R.CommonCode.NO_DATA, R.CommonMessage.RESULT_NO_DATA);
	}
	public static<T> R<T> duplicate(){
		return getInstance(true, null,  R.CommonCode.RESULT_DUPLICATE, R.CommonMessage.RESULT_DUPLICATE);
	}
	public static<T> R<T> success(){
		return getInstance(false, null, R.CommonCode.SUCCESS, R.CommonMessage.SUCCESS);
	}

	public static<T> R<T> success(T data){
		return getInstance(false, data, R.CommonCode.SUCCESS, R.CommonMessage.SUCCESS);
	}

	public static<T> R<T> success(String code, String message, T data){
		return getInstance(false, data, code, message);
	}

	public static<T> R<T> error(){
		return getInstance(true, null, R.CommonCode.ERROR, R.CommonMessage.ERROR);
	}

	public static<T> R<T> error(String code, String message){
		return getInstance(true, null, code,message);
	}

	/**
	 *
	 * @param data
	 * @param <T>
	 * @return
	 */
	@Deprecated
	public static<T> R<T> error(T data){
		return getInstance(true, data, R.CommonCode.ERROR, R.CommonMessage.ERROR);
	}

	public static <T> R<T> errorWithMsg(String message){
		return getInstance(true,null,R.CommonCode.ERROR,message);
	}

	public static<T> R<T> error(String code, String message,T data){
		return getInstance(true, data, code,message);
	}

	public String  getRequestId(){
		if (isError != null && isError) {
			log.warn("返回错误{}",message);
		}
		return MDC.get("TRACE_ID");
	}

	public String getP(){
		return p;
	}

}
