/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.problem;

import com.ovopark.check.problem.Subject;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class Option {
    private Integer choiceQuestionType;
    private BigDecimal mark;
    private BigDecimal totalMark;
    private boolean editable = false;
    private List<Subject> subject;
    private Integer scoreType;
    private List<BigDecimal> customMark;
    private BigDecimal step;

    public BigDecimal getMark() {
        if (this.checkIsCommonQuestion()) {
            return this.mark;
        }
        if (CollectionUtils.isEmpty(this.subject)) {
            return BigDecimal.ZERO;
        }
        List selected = this.subject.stream().filter(Subject::isChoiceStatus).map(Subject::getChoiceQuestionMark).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(selected)) {
            return BigDecimal.ZERO;
        }
        return selected.stream().map(BigDecimal::new).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getTotalMark() {
        if (this.checkIsCommonQuestion()) {
            return this.totalMark;
        }
        if (CollectionUtils.isEmpty(this.subject)) {
            return BigDecimal.ZERO;
        }
        if (this.choiceQuestionType == 0) {
            return this.subject.stream().map(Subject::getChoiceQuestionMark).map(BigDecimal::new).max(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
        }
        return this.subject.stream().map(Subject::getChoiceQuestionMark).map(BigDecimal::new).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public boolean checkIsChoiceQuestion() {
        return Objects.equals(this.choiceQuestionType, 0) || Objects.equals(this.choiceQuestionType, 1);
    }

    public boolean checkIsCommonQuestion() {
        return Objects.equals(this.choiceQuestionType, 2);
    }

    public boolean checkIsCustomScoreType() {
        return Objects.equals(this.scoreType, 1);
    }

    public Integer getChoiceQuestionType() {
        return this.choiceQuestionType;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public List<Subject> getSubject() {
        return this.subject;
    }

    public Integer getScoreType() {
        return this.scoreType;
    }

    public List<BigDecimal> getCustomMark() {
        return this.customMark;
    }

    public BigDecimal getStep() {
        return this.step;
    }

    public void setChoiceQuestionType(Integer choiceQuestionType) {
        this.choiceQuestionType = choiceQuestionType;
    }

    public void setMark(BigDecimal mark) {
        this.mark = mark;
    }

    public void setTotalMark(BigDecimal totalMark) {
        this.totalMark = totalMark;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setSubject(List<Subject> subject) {
        this.subject = subject;
    }

    public void setScoreType(Integer scoreType) {
        this.scoreType = scoreType;
    }

    public void setCustomMark(List<BigDecimal> customMark) {
        this.customMark = customMark;
    }

    public void setStep(BigDecimal step) {
        this.step = step;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Option)) {
            return false;
        }
        Option other = (Option)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$choiceQuestionType = this.getChoiceQuestionType();
        Integer other$choiceQuestionType = other.getChoiceQuestionType();
        if (this$choiceQuestionType == null ? other$choiceQuestionType != null : !((Object)this$choiceQuestionType).equals(other$choiceQuestionType)) {
            return false;
        }
        BigDecimal this$mark = this.getMark();
        BigDecimal other$mark = other.getMark();
        if (this$mark == null ? other$mark != null : !((Object)this$mark).equals(other$mark)) {
            return false;
        }
        BigDecimal this$totalMark = this.getTotalMark();
        BigDecimal other$totalMark = other.getTotalMark();
        if (this$totalMark == null ? other$totalMark != null : !((Object)this$totalMark).equals(other$totalMark)) {
            return false;
        }
        if (this.isEditable() != other.isEditable()) {
            return false;
        }
        List<Subject> this$subject = this.getSubject();
        List<Subject> other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !((Object)this$subject).equals(other$subject)) {
            return false;
        }
        Integer this$scoreType = this.getScoreType();
        Integer other$scoreType = other.getScoreType();
        if (this$scoreType == null ? other$scoreType != null : !((Object)this$scoreType).equals(other$scoreType)) {
            return false;
        }
        List<BigDecimal> this$customMark = this.getCustomMark();
        List<BigDecimal> other$customMark = other.getCustomMark();
        if (this$customMark == null ? other$customMark != null : !((Object)this$customMark).equals(other$customMark)) {
            return false;
        }
        BigDecimal this$step = this.getStep();
        BigDecimal other$step = other.getStep();
        return !(this$step == null ? other$step != null : !((Object)this$step).equals(other$step));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Option;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $choiceQuestionType = this.getChoiceQuestionType();
        result = result * 59 + ($choiceQuestionType == null ? 43 : ((Object)$choiceQuestionType).hashCode());
        BigDecimal $mark = this.getMark();
        result = result * 59 + ($mark == null ? 43 : ((Object)$mark).hashCode());
        BigDecimal $totalMark = this.getTotalMark();
        result = result * 59 + ($totalMark == null ? 43 : ((Object)$totalMark).hashCode());
        result = result * 59 + (this.isEditable() ? 79 : 97);
        List<Subject> $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : ((Object)$subject).hashCode());
        Integer $scoreType = this.getScoreType();
        result = result * 59 + ($scoreType == null ? 43 : ((Object)$scoreType).hashCode());
        List<BigDecimal> $customMark = this.getCustomMark();
        result = result * 59 + ($customMark == null ? 43 : ((Object)$customMark).hashCode());
        BigDecimal $step = this.getStep();
        result = result * 59 + ($step == null ? 43 : ((Object)$step).hashCode());
        return result;
    }

    public String toString() {
        return "Option(choiceQuestionType=" + this.getChoiceQuestionType() + ", mark=" + this.getMark() + ", totalMark=" + this.getTotalMark() + ", editable=" + this.isEditable() + ", subject=" + this.getSubject() + ", scoreType=" + this.getScoreType() + ", customMark=" + this.getCustomMark() + ", step=" + this.getStep() + ")";
    }
}

