package com.ovopark.check.Vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;

import java.util.List;

@NoArgsConstructor
@AllArgsConstructor
@Data
public class PicVideoNoteBlockConfigBo {
    // 是否匹配到屏蔽规则
    private Boolean enableBlock;
    // 是否屏蔽所有检查项
    private Boolean blockAllInspItems;
    // 被屏蔽的检查项id
    private List<Integer> InspItemsBlockedIds;
    // 被屏蔽的数据类型（PIC_VIDEO-点检项的图片&视频, NOTE-点检项的备注）
    private List<String> InspItemsContentBlocked;
    public boolean blockPicVideo() {
        return enableBlock && CollectionUtils.isNotEmpty(InspItemsContentBlocked) && InspItemsContentBlocked.contains("PIC_VIDEO");
    }
    public boolean blockNote() {
        return enableBlock && CollectionUtils.isNotEmpty(InspItemsContentBlocked) && InspItemsContentBlocked.contains("NOTE");
    }
}
