/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.shopwebdetecttoolkit.utils;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.MDC;
import org.springframework.util.StringUtils;

public class TraceIdUtils {
    public static final String TRACEID = "TraceId";

    private static String createUUID() {
        return UUID.randomUUID().toString();
    }

    public static void initTraceId(HttpServletRequest request) {
        String traceId = request.getHeader(TRACEID);
        if (StringUtils.isEmpty((Object)traceId)) {
            traceId = TraceIdUtils.createUUID();
        }
        MDC.put((String)TRACEID, (String)traceId);
    }

    public static void removeTraceId() {
        MDC.remove((String)TRACEID);
    }

    public static String getTraceId() {
        return MDC.get((String)TRACEID);
    }

    public static void putTraceIdToResponseHeader(HttpServletResponse httpServletResponse) {
        httpServletResponse.addHeader(TRACEID, TraceIdUtils.getTraceId());
    }
}

