/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.shopwebdetecttoolkit.filter;

import com.alibaba.fastjson.JSON;
import com.ovopark.shopwebdetecttoolkit.filter.RequestWrapper;
import com.ovopark.shopwebdetecttoolkit.filter.ResponseWrapper;
import java.io.IOException;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.util.StringUtils;

public class FilterTool
implements Filter {
    private static Logger log = LoggerFactory.getLogger(FilterTool.class);
    private static final long TIMEOUT_THRESHOLD = 3000L;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String params;
        long startTime = System.currentTimeMillis();
        Object request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String requestId = request.getHeader("requestId");
        String traceId = request.getHeader("TraceId");
        if (requestId == null || requestId.isEmpty()) {
            requestId = traceId;
        }
        if (requestId == null || requestId.isEmpty()) {
            requestId = UUID.randomUUID().toString();
        }
        MDC.put((String)"TraceId", (String)requestId);
        String contentType = request.getContentType();
        RequestWrapper wrapper = null;
        if (!StringUtils.isEmpty((Object)contentType) && contentType.contains("application/json")) {
            wrapper = new RequestWrapper((HttpServletRequest)request);
            params = wrapper.getBody();
            request = wrapper;
        } else {
            params = JSON.toJSONString((Object)request.getParameterMap());
        }
        MDC.put((String)"params", (String)params);
        String userAgent = request.getHeader("User-Agent");
        String requestURL = request.getRequestURL() != null ? request.getRequestURL().toString() : "";
        log.info("\u8bf7\u6c42\u5730\u5740\uff1a{} ;\u8bf7\u6c42\u53c2\u6570\uff1a{}; User-Agent\uff1a{}", new Object[]{requestURL, params, userAgent});
        ResponseWrapper wrapperResponse = new ResponseWrapper(response);
        if (wrapper == null) {
            wrapper = new RequestWrapper((HttpServletRequest)request);
            wrapper.addHeader("TraceId", requestId);
            filterChain.doFilter((ServletRequest)wrapper, (ServletResponse)wrapperResponse);
        } else {
            wrapper.addHeader("TraceId", requestId);
            filterChain.doFilter((ServletRequest)wrapper, (ServletResponse)wrapperResponse);
        }
        try {
            byte[] bytes = wrapperResponse.getBytes();
            if (bytes.length > 0) {
                String str = new String(bytes, "UTF-8");
                long endTime = System.currentTimeMillis();
                long duration = endTime - startTime;
                if (duration > 3000L) {
                    log.error("\u63a5\u53e3\u8c03\u7528\u8d85\u65f6 - \u8bf7\u6c42\u5730\u5740: {}; \u6267\u884c\u65f6\u95f4: {}ms; \u8d85\u65f6\u9608\u503c: {}ms", new Object[]{requestURL, duration, 3000L});
                }
                log.info("\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)str);
            }
            ServletOutputStream out = response.getOutputStream();
            out.write(bytes);
            out.flush();
        }
        catch (Exception e) {
            log.error("\u8f93\u51fa\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        finally {
            MDC.clear();
        }
    }
}

