/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.shopwebdetecttoolkit.tools.trace;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.MDC;
import org.springframework.util.StringUtils;

public class TraceIdUtils {
    public static final String TRACEID = "TraceId";
    public static final String REQUEST_ID = "requestId";

    private static String createUUID() {
        return UUID.randomUUID().toString();
    }

    protected static void initTraceId(HttpServletRequest request) {
        String traceId = request.getHeader(TRACEID);
        if (StringUtils.isEmpty((Object)traceId)) {
            traceId = TraceIdUtils.createUUID();
        }
        MDC.put((String)TRACEID, (String)traceId);
    }

    protected static void removeTraceId() {
        MDC.remove((String)TRACEID);
    }

    protected static String getTraceId() {
        return MDC.get((String)TRACEID);
    }

    protected static void putTraceIdToResponseHeader(HttpServletResponse httpServletResponse) {
        httpServletResponse.addHeader(TRACEID, TraceIdUtils.getTraceId());
    }
}

