/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.ObjectMetadata;
import com.ovopark.oss.AliyunPropUtil;
import com.ovopark.utils.DateUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Date;
import java.util.Random;
import org.springframework.util.StringUtils;

public class OssHelper {
    private static String ossBucketName;
    private static String ossEndPoint;
    private static String accessKeyId;
    private static String accessKeySecret;
    private static String accessUrl;
    private static String roleArn;
    private static String authAccessKeyId;
    private static String authAccessKeySecret;
    private static String region;

    public static String uploadFile(File file) {
        String newFileName = OssHelper.genImageName(file.getName());
        String imagePath = OssHelper.getImagePath(newFileName);
        OssHelper.putObject(file, newFileName, imagePath);
        return imagePath;
    }

    public static String uploadFile(InputStream inputStream, String ext) {
        String newFileName = OssHelper.genImageName(ext);
        String imagePath = OssHelper.getImagePath(newFileName);
        OssHelper.putObject(inputStream, newFileName, imagePath);
        return imagePath;
    }

    public static String uploadOriginFile(InputStream inputStream, String ext) {
        String imagePath = OssHelper.getImagePath(ext);
        OssHelper.putObject(inputStream, ext, imagePath);
        return imagePath;
    }

    public static String uploadFileNew(InputStream inputStream, String ext) {
        String newFileName = OssHelper.genImageName(ext);
        String imagePath = OssHelper.getImagePath(newFileName);
        OssHelper.putObject(inputStream, newFileName, imagePath);
        return accessUrl + "/" + imagePath;
    }

    public static String uploadFile(File file, String ext) {
        if (StringUtils.isEmpty((Object)ext)) {
            ext = "jpg";
        }
        String newFileName = OssHelper.genImageName(file.getName());
        if (!StringUtils.isEmpty((Object)ext)) {
            newFileName = newFileName.substring(0, newFileName.lastIndexOf(".") + 1) + ext;
        }
        String imagePath = OssHelper.getImagePath(newFileName);
        OssHelper.putObject(file, newFileName, imagePath);
        return imagePath;
    }

    public static String uploadFile(byte[] file) {
        String newFileName = OssHelper.genImageName(OssHelper.getRandomString(32) + ".jpg");
        String imagePath = OssHelper.getImagePath(newFileName);
        OssHelper.putObject(file, newFileName, imagePath);
        return imagePath;
    }

    public static String uploadFileWithName(File file, String fileName) {
        String newFileName = OssHelper.genImageName(file.getName());
        if (!StringUtils.isEmpty((Object)fileName)) {
            newFileName = fileName;
        }
        String imagePath = OssHelper.getImagePath(newFileName);
        OssHelper.putObject(file, newFileName, imagePath);
        return imagePath;
    }

    public static String getRandomString(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static String uploadLocalFile(String localFilePath) {
        String newFileName = OssHelper.genImageName(localFilePath.substring(localFilePath.lastIndexOf("/") + 1));
        String imagePath = OssHelper.getImagePath(newFileName);
        OssHelper.putObject(new File(localFilePath), newFileName, imagePath);
        return imagePath;
    }

    private static String getFileNameByUrl(String fileUrl) {
        int beginIndex = fileUrl.indexOf(accessUrl);
        int endIndex = fileUrl.indexOf("?");
        int endIndex2 = fileUrl.indexOf("@!");
        if (beginIndex == -1) {
            return null;
        }
        if (endIndex != -1) {
            return fileUrl.substring(beginIndex + accessUrl.length(), endIndex);
        }
        if (endIndex2 != -1) {
            return fileUrl.substring(beginIndex + accessUrl.length(), endIndex2);
        }
        return fileUrl.substring(beginIndex + accessUrl.length() + 1);
    }

    private static String contentType(String fileType) {
        fileType = fileType.toLowerCase();
        String contentType = "";
        switch (fileType) {
            case "bmp": {
                contentType = "image/bmp";
                break;
            }
            case "gif": {
                contentType = "image/gif";
                break;
            }
            case "png": 
            case "jpeg": 
            case "jpg": {
                contentType = "image/jpeg";
                break;
            }
            case "html": {
                contentType = "text/html";
                break;
            }
            case "txt": {
                contentType = "text/plain";
                break;
            }
            case "vsd": {
                contentType = "application/vnd.visio";
                break;
            }
            case "ppt": 
            case "pptx": {
                contentType = "application/vnd.ms-powerpoint";
                break;
            }
            case "doc": 
            case "docx": {
                contentType = "application/msword";
                break;
            }
            case "xml": {
                contentType = "text/xml";
                break;
            }
            case "mp4": {
                contentType = "video/mp4";
                break;
            }
            default: {
                contentType = "application/octet-stream";
            }
        }
        return contentType;
    }

    public static String genImageName(String suffix) {
        String extName = suffix.substring(suffix.lastIndexOf("."));
        long millis = System.currentTimeMillis();
        Random random = new Random();
        int end3 = random.nextInt(999);
        String str = millis + String.format("%03d", end3);
        return str + extName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putObject(File file, String fileName, String imagePath) {
        OSSClient client = null;
        try {
            client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
            FileInputStream input = new FileInputStream(file);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType(OssHelper.contentType(fileName.substring(fileName.lastIndexOf(".") + 1)));
            meta.setCacheControl("no-cache");
            client.putObject(ossBucketName, imagePath, (InputStream)input, meta);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            client.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putObject(byte[] file, String fileName, String imagePath) {
        OSSClient client = null;
        try {
            client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType(OssHelper.contentType(fileName.substring(fileName.lastIndexOf(".") + 1)));
            meta.setCacheControl("no-cache");
            client.putObject(ossBucketName, imagePath, (InputStream)new ByteArrayInputStream(file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            client.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putObject(InputStream input, String fileName, String imagePath) {
        OSSClient client = null;
        try {
            client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType(OssHelper.contentType(fileName.substring(fileName.lastIndexOf(".") + 1)));
            meta.setCacheControl("no-cache");
            client.putObject(ossBucketName, imagePath, input, meta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            client.shutdown();
        }
    }

    public static String getImagePath(String imageName) {
        return DateUtils.format(new Date(), "yyyy/MM/dd") + "/" + imageName;
    }

    public static String getOssBucketName() {
        return ossBucketName;
    }

    public static String getOssEndPoint() {
        return ossEndPoint;
    }

    static {
        accessKeyId = AliyunPropUtil.readStringValue("aliyun.accessKeyId");
        accessKeySecret = AliyunPropUtil.readStringValue("aliyun.accessKeySecret");
        ossEndPoint = AliyunPropUtil.readStringValue("oss.endpoint");
        ossBucketName = AliyunPropUtil.readStringValue("oss.bucketName");
        accessUrl = AliyunPropUtil.readStringValue("oss.accessUrl");
        region = AliyunPropUtil.readStringValue("region");
        roleArn = AliyunPropUtil.readStringValue("roleArn");
        authAccessKeyId = AliyunPropUtil.readStringValue("authAccessKeyId");
        authAccessKeySecret = AliyunPropUtil.readStringValue("authAccessKeySecret");
    }

    public abstract class AliyunPropKey {
        public static final String ALIYUN_ACCESSKEYID = "aliyun.accessKeyId";
        public static final String ALIYUN_ACCESSKEYSECRET = "aliyun.accessKeySecret";
        public static final String OSS_ENDPOINT = "oss.endpoint";
        public static final String OSS_BUCKETNAME = "oss.bucketName";
        public static final String OSS_ACCESSURL = "oss.accessUrl";
    }
}

