/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    public static final String LONG_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String SHORT_FORMAT_PATTERN = "yyyy-MM-dd";

    public static String format(Date date, String formatPattern) {
        if (date == null || StringUtils.isBlank((CharSequence)formatPattern)) {
            throw new RuntimeException("\u4f20\u5165\u53c2\u6570\u5f02\u5e38\uff0c\u65e5\u671fformat\u62a5\u9519");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(formatPattern);
        return sdf.format(date);
    }

    public static Date parse(String time, String formatPattern) {
        if (StringUtils.isBlank((CharSequence)time) || StringUtils.isBlank((CharSequence)formatPattern)) {
            throw new RuntimeException("\u4f20\u5165\u53c2\u6570\u5f02\u5e38\uff0c\u65e5\u671f\u5b57\u7b26\u4e32parse\u62a5\u9519");
        }
        SimpleDateFormat f = new SimpleDateFormat(formatPattern);
        try {
            return f.parse(time);
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f\u5b57\u7b26\u4e32\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static String formatLongDate(Date date) {
        return DateUtils.format(date, LONG_FORMAT_PATTERN);
    }

    public static String formatShortDate(Date date) {
        return DateUtils.format(date, SHORT_FORMAT_PATTERN);
    }

    public static Date timeStr2Date(String time) {
        if (StringUtils.isBlank((CharSequence)time)) {
            return null;
        }
        try {
            if (DateUtils.isValidDatePattern(time)) {
                return DateUtils.parse(time, SHORT_FORMAT_PATTERN);
            }
            if (DateUtils.isValidDateTimePattern(time)) {
                return DateUtils.parse(time, LONG_FORMAT_PATTERN);
            }
            if (time.length() == 13) {
                return new Date(Long.valueOf(time));
            }
            if (time.length() == 10) {
                return new Date(Long.valueOf(time) * 1000L);
            }
        }
        catch (NumberFormatException e) {
            log.error("timeStr2Date error", (Throwable)e);
        }
        return null;
    }

    public static boolean isValidDatePattern(String dateStr) {
        String regex = "^\\d{4}-\\d{2}-\\d{2}$";
        return dateStr.matches(regex);
    }

    public static boolean isValidDateTimePattern(String dateTimeStr) {
        String regex = "^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}$";
        return dateTimeStr.matches(regex);
    }

    public static Date getHourDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static int getHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(11);
    }

    public static long getIntervalSeconds(Date start, Date end) {
        return (end.getTime() - start.getTime()) / 1000L;
    }

    public static List<Date> getIntervalHourDates(Date start, Date end) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(start);
        ArrayList<Date> dates = new ArrayList<Date>();
        calendar.add(11, 1);
        while (calendar.getTime().before(end)) {
            dates.add(DateUtils.getHourDate(calendar.getTime()));
            calendar.add(11, 1);
        }
        return dates;
    }

    public static Date addSeconds(Date date, int seconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, seconds);
        return calendar.getTime();
    }

    public static Date getEndTimeOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getStartTimeOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Pair<String, String> getDayStartTimeAndEndTimeByNow(Date now) {
        Date startTimeOfDay = DateUtils.getStartTimeOfDay(now);
        String stime = DateUtils.formatLongDate(startTimeOfDay);
        Date endTimeOfDay = DateUtils.getEndTimeOfDay(now);
        String etime = DateUtils.formatLongDate(endTimeOfDay);
        return Pair.of((Object)stime, (Object)etime);
    }
}

