/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.fix.aggregate;

import com.ovopark.passenger.common.Aggregate;
import com.ovopark.passenger.common.util.DateUtils;
import com.ovopark.passenger.common.util.NumberUtils;
import com.ovopark.passenger.core.entity.CustomerFlowHourly;
import com.ovopark.passenger.core.entity.CustomerFlowHourlyRepository;
import com.ovopark.passenger.core.entity.Product;
import com.ovopark.passenger.core.entity.ProductRepository;
import com.ovopark.passenger.exception.ExceptionService;
import com.ovopark.passenger.exception.ResultCodeEnum;
import com.ovopark.passenger.fix.entity.PassengerFixData;
import com.ovopark.passenger.fix.entity.PassengerFixDataRepository;
import com.ovopark.passenger.fix.entity.PassengerFixOperate;
import com.ovopark.passenger.fix.entity.PassengerFixOperateRepository;
import com.ovopark.passenger.fix.entity.PassengerFlowCorrection;
import com.ovopark.passenger.fix.event.AntaPushTrafficDataEvent;
import com.ovopark.passenger.fix.event.CustomerGroupPushEvent;
import com.ovopark.passenger.fix.event.FilaPushTimePointEvent;
import com.ovopark.passenger.fix.event.IndicatorDataPushEvent;
import com.ovopark.passenger.fix.event.PushTimePointEvent;
import com.ovopark.passenger.support.Department;
import com.ovopark.passenger.support.DeviceStatus;
import com.ovopark.passenger.support.User;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public class PassengerFixAggregate
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(PassengerFixAggregate.class);
    private static final long serialVersionUID = 8808041046492955592L;
    private List<PassengerFlowCorrection> corrections;
    private User user;
    private Department department;
    private DeviceStatus device;
    private Integer productId;
    private Integer operateType;
    private List<Integer> primaryBroTagFixDataTypes;
    private PassengerFixOperate operate;
    private List<PassengerFixData> dataList;
    private CustomerFlowHourlyRepository customerFlowHourlyRepository;
    private PassengerFixOperateRepository passengerFixOperateRepository;
    private PassengerFixDataRepository passengerFixDataRepository;
    private ApplicationContext applicationContext;
    private ProductRepository productRepository;
    private ExceptionService exceptionService;

    public List<PassengerFlowCorrection> getCorrections() {
        return this.corrections;
    }

    public void setCorrections(List<PassengerFlowCorrection> corrections) {
        this.corrections = corrections;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public DeviceStatus getDevice() {
        return this.device;
    }

    public void setDevice(DeviceStatus device) {
        this.device = device;
    }

    public PassengerFixOperate getOperate() {
        return this.operate;
    }

    public void setOperate(PassengerFixOperate operate) {
        this.operate = operate;
    }

    public List<PassengerFixData> getDataList() {
        return this.dataList;
    }

    public void setDataList(List<PassengerFixData> dataList) {
        this.dataList = dataList;
    }

    public Integer getOperateType() {
        return this.operateType;
    }

    public void setOperateType(Integer operateType) {
        this.operateType = operateType;
    }

    public List<Integer> getPrimaryBroTagFixDataTypes() {
        return this.primaryBroTagFixDataTypes;
    }

    public void setPrimaryBroTagFixDataTypes(List<Integer> primaryBroTagFixDataTypes) {
        this.primaryBroTagFixDataTypes = primaryBroTagFixDataTypes;
    }

    public void setCustomerFlowHourlyRepository(CustomerFlowHourlyRepository customerFlowHourlyRepository) {
        this.customerFlowHourlyRepository = customerFlowHourlyRepository;
    }

    public void setPassengerFixOperateRepository(PassengerFixOperateRepository passengerFixOperateRepository) {
        this.passengerFixOperateRepository = passengerFixOperateRepository;
    }

    public void setPassengerFixDataRepository(PassengerFixDataRepository passengerFixDataRepository) {
        this.passengerFixDataRepository = passengerFixDataRepository;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Integer getProductId() {
        return this.productId;
    }

    public void setProductId(Integer productId) {
        this.productId = productId;
    }

    public void setProductRepository(ProductRepository productRepository) {
        this.productRepository = productRepository;
    }

    public void setExceptionService(ExceptionService exceptionService) {
        this.exceptionService = exceptionService;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PassengerFixAggregate that = (PassengerFixAggregate)o;
        return Objects.equals(this.corrections, that.corrections) && Objects.equals(this.user, that.user) && Objects.equals(this.department, that.department) && Objects.equals(this.device, that.device) && Objects.equals(this.productId, that.productId) && Objects.equals(this.operateType, that.operateType) && Objects.equals(this.operate, that.operate) && Objects.equals(this.dataList, that.dataList) && Objects.equals(this.customerFlowHourlyRepository, that.customerFlowHourlyRepository) && Objects.equals(this.passengerFixOperateRepository, that.passengerFixOperateRepository) && Objects.equals(this.passengerFixDataRepository, that.passengerFixDataRepository) && Objects.equals(this.applicationContext, that.applicationContext);
    }

    public int hashCode() {
        return Objects.hash(this.corrections, this.user, this.department, this.device, this.productId, this.operateType, this.operate, this.dataList, this.customerFlowHourlyRepository, this.passengerFixOperateRepository, this.passengerFixDataRepository, this.applicationContext);
    }

    public String toString() {
        return "PassengerFixAggregate{corrections=" + this.corrections + ", user=" + this.user + ", department=" + this.department + ", device=" + this.device + ", productId=" + this.productId + ", operateType=" + this.operateType + ", operate=" + this.operate + ", dataList=" + this.dataList + ", customerFlowHourlyRepository=" + this.customerFlowHourlyRepository + ", passengerFixOperateRepository=" + this.passengerFixOperateRepository + ", passengerFixDataRepository=" + this.passengerFixDataRepository + ", applicationContext=" + this.applicationContext + '}';
    }

    public void fix() {
        log.info("\u5f85\u64cd\u4f5c:{}", (Object)this);
        if (CollectionUtils.isEmpty(this.corrections)) {
            log.warn("corrections is empty");
            return;
        }
        if (this.user == null) {
            log.warn("user is null");
            return;
        }
        if (this.department == null) {
            log.warn("department is null");
            return;
        }
        if (this.device == null) {
            log.warn("device is null");
            return;
        }
        if (this.operateType == null) {
            log.warn("operateType is null");
            return;
        }
        if (this.customerFlowHourlyRepository == null) {
            log.warn("customerFlowHourlyRepository is null");
            return;
        }
        if (this.passengerFixOperateRepository == null) {
            log.warn("passengerFixOperateRepository is null");
            return;
        }
        if (this.passengerFixDataRepository == null) {
            log.warn("passengerFixDataRepository is null");
            return;
        }
        if (this.applicationContext == null) {
            log.warn("applicationContext is null");
            return;
        }
        if (this.productRepository == null) {
            log.warn("productRepository is null");
            return;
        }
        if (this.exceptionService == null) {
            log.warn("exceptionService is null");
            return;
        }
        Product product = null;
        if (this.productId != null && (product = this.productRepository.getById(this.productId)) == null) {
            this.exceptionService.throwBizException(ResultCodeEnum.EMPTY_PRODUCT.getCode(), ResultCodeEnum.EMPTY_PRODUCT.getMessage());
        }
        Date now = new Date();
        this.operate = new PassengerFixOperate().setDepId(this.department.getId()).setDepName(this.department.getName()).setMac(this.device.getMac()).setDeviceName(this.device.getName()).setProductId(this.productId).setProductName(product != null ? product.getName() : null).setUserId(this.user.getId()).setUserName(this.user.getUserName()).setOperateType(this.operateType).setOperateTime(now).setOperateDate(DateUtils.timeStr2Date(DateUtils.formatShortDate(this.corrections.get(0).getRecordTime()))).setOperateType(this.operateType);
        this.passengerFixOperateRepository.save(this.operate);
        Integer operateId = this.operate.getId();
        if (operateId == null) {
            log.warn("operateId is null");
            return;
        }
        this.dataList = new ArrayList<PassengerFixData>();
        HashSet<Date> recordTimes = new HashSet<Date>();
        HashSet<Date> enterFixTimes = new HashSet<Date>();
        for (PassengerFlowCorrection correction : this.corrections) {
            log.info("\u5f85\u5904\u7406correction:{}", (Object)correction);
            Aggregate<CustomerFlowHourly> update = this.customerFlowHourlyRepository.update(this.device, this.productId, correction, this.operateType);
            if (update == null) {
                log.warn("update is null");
                continue;
            }
            CustomerFlowHourly root = update.getRoot();
            if (root == null) {
                log.warn("update fail, root is null");
                continue;
            }
            CustomerFlowHourly incrementFlow = new CustomerFlowHourly();
            BeanUtils.copyProperties((Object)root, (Object)incrementFlow);
            incrementFlow.setId(null);
            incrementFlow.setInCount1(update.getSnapshot() == null ? root.getInCount1() : root.getInCount1() - update.getSnapshot().getInCount1());
            incrementFlow.setOutCount1(update.getSnapshot() == null ? root.getOutCount1() : root.getOutCount1() - update.getSnapshot().getOutCount1());
            this.applicationContext.publishEvent((ApplicationEvent)new AntaPushTrafficDataEvent(this, this.department, correction.getTag(), incrementFlow));
            recordTimes.add(root.getRecordTime());
            if (correction.getFixDataType() == 0) {
                enterFixTimes.add(root.getRecordTime());
            }
            PassengerFixData data = new PassengerFixData();
            data.setOperateId(operateId);
            data.setTime(correction.getRecordTime());
            data.setFlow(this.getFlowCount(root, correction.getFixDataType(), this.primaryBroTagFixDataTypes));
            data.setInitialFlow(this.getFlowCount(update.getSnapshot(), correction.getFixDataType(), this.primaryBroTagFixDataTypes));
            data.setType(correction.getFixDataType());
            this.passengerFixDataRepository.save(data);
            this.dataList.add(data);
            Integer subtract = NumberUtils.getSubtract(data.getFlow(), data.getInitialFlow());
            if (subtract == null) continue;
            if (subtract > 0) {
                this.operate.setAddCount(NumberUtils.getOrDefault(this.operate.getAddCount()) + subtract);
                this.operate.setFixCount(NumberUtils.getOrDefault(this.operate.getFixCount()) + subtract);
            }
            if (subtract >= 0) continue;
            this.operate.setReduceCount(NumberUtils.getOrDefault(this.operate.getReduceCount()) - subtract);
            this.operate.setFixCount(NumberUtils.getOrDefault(this.operate.getFixCount()) - subtract);
        }
        this.passengerFixOperateRepository.updateById(this.operate);
        recordTimes.forEach(recordTime -> this.applicationContext.publishEvent((ApplicationEvent)new IndicatorDataPushEvent(this, this.department.getEnterpriseId(), this.department.getId(), (Date)recordTime)));
        recordTimes.forEach(recordTime -> this.applicationContext.publishEvent((ApplicationEvent)new FilaPushTimePointEvent(this, this.department.getEnterpriseId(), this.department.getId(), (Date)recordTime)));
        enterFixTimes.forEach(recordTime -> this.applicationContext.publishEvent((ApplicationEvent)new CustomerGroupPushEvent(this, this.department.getEnterpriseId(), this.department.getId(), (Date)recordTime)));
        recordTimes.forEach(recordTime -> this.applicationContext.publishEvent((ApplicationEvent)new PushTimePointEvent(this, this.department.getEnterpriseId(), this.department.getId(), (Date)recordTime)));
    }

    private Integer getFlowCount(CustomerFlowHourly flow, Integer fixDataType, List<Integer> primaryBroTagFixDataTypes) {
        if (flow == null) {
            return 0;
        }
        if (CollectionUtils.isNotEmpty(primaryBroTagFixDataTypes) && primaryBroTagFixDataTypes.contains(fixDataType)) {
            return flow.getInCount1();
        }
        switch (fixDataType) {
            case 2: {
                return flow.getInCount1() + flow.getOutCount1();
            }
            case 1: 
            case 5: {
                return flow.getOutCount1();
            }
            case 0: 
            case 3: 
            case 4: {
                return flow.getInCount1();
            }
        }
        return null;
    }
}

