/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.shopweb.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import sun.misc.BASE64Encoder;

public class QCloudUtils {
    public static final String SECRET_ID = "AKIDYyGF2g6OCvSnvrH940mMjusfFersmIiw";
    public static final String SECRET_KEY = "9ayCGAvXBiKp9lFb6RaXIqKjwxpW0IOi";
    private static final String CONTENT_CHARSET = "UTF-8";
    private static final String HMAC_ALGORITHM = "HmacSHA1";

    public static String getDescribeVodPlayInfo(String fileName) {
        TreeMap<String, Object> requestParams = new TreeMap<String, Object>();
        requestParams.put("Action", "DescribeVodPlayInfo");
        requestParams.put("fileName", fileName);
        requestParams.put("Timestamp", System.currentTimeMillis() / 1000L);
        requestParams.put("Region", "gz");
        Random rand = new Random();
        requestParams.put("Nonce", rand.nextInt(Integer.MAX_VALUE));
        requestParams.put("SecretId", SECRET_ID);
        String requestMethod = "GET";
        String requestHost = "vod.api.qcloud.com";
        String requestPath = "/v2/index.php";
        try {
            String plainText = QCloudUtils.makeSignPlainText(requestParams, requestMethod, requestHost, requestPath);
            String sign = QCloudUtils.sign(plainText, SECRET_KEY);
            System.out.println("\u539f\u6587: " + plainText);
            System.out.println("\u7b7e\u540d: " + sign);
            requestParams.put("Signature", sign);
            String retStr = QCloudUtils.sendRequest("https://" + requestHost + requestPath, requestParams, requestMethod);
            return retStr;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public static String sign(String signStr, String secret) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeyException {
        String sig = null;
        Mac mac = Mac.getInstance(HMAC_ALGORITHM);
        SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(CONTENT_CHARSET), mac.getAlgorithm());
        mac.init(secretKey);
        byte[] hash = mac.doFinal(signStr.getBytes(CONTENT_CHARSET));
        sig = new String(new BASE64Encoder().encode(hash).getBytes());
        return sig;
    }

    public static String makeSignPlainText(TreeMap<String, Object> requestParams) {
        return QCloudUtils.makeSignPlainText(requestParams, "GET", "cvm.api.qcloud.com", "/v2/index.php");
    }

    public static String makeSignPlainText(TreeMap<String, Object> requestParams, String requestMethod) {
        return QCloudUtils.makeSignPlainText(requestParams, requestMethod, "cvm.api.qcloud.com", "/v2/index.php");
    }

    public static String makeSignPlainText(TreeMap<String, Object> requestParams, String requestMethod, String requestHost) {
        return QCloudUtils.makeSignPlainText(requestParams, requestMethod, requestHost, "/v2/index.php");
    }

    public static String makeSignPlainText(TreeMap<String, Object> requestParams, String requestMethod, String requestHost, String requestPath) {
        String retStr = "";
        retStr = retStr + requestMethod;
        retStr = retStr + requestHost;
        retStr = retStr + requestPath;
        retStr = retStr + QCloudUtils._buildParamStr(requestParams);
        return retStr;
    }

    protected static String _buildParamStr(TreeMap<String, Object> requestParams) {
        return QCloudUtils._buildParamStr(requestParams, "GET");
    }

    protected static String _buildParamStr(TreeMap<String, Object> requestParams, String requestMethod) {
        String retStr = "";
        for (String key : requestParams.keySet()) {
            if (key.equals("Signature")) continue;
            retStr = retStr.isEmpty() ? retStr + '?' : retStr + '&';
            retStr = retStr + key.replace("_", ".") + '=' + requestParams.get(key).toString();
        }
        return retStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendRequest(String url, Map<String, Object> requestParams, String requestMethod) {
        String result = "";
        BufferedReader in = null;
        String paramStr = "";
        for (String key : requestParams.keySet()) {
            if (!paramStr.isEmpty()) {
                paramStr = paramStr + '&';
            }
            paramStr = paramStr + key + '=' + URLEncoder.encode(requestParams.get(key).toString());
        }
        try {
            String line;
            if (requestMethod.equals("GET")) {
                url = url.indexOf(63) > 0 ? url + '&' + paramStr : url + '?' + paramStr;
            }
            URL realUrl = new URL(url);
            URLConnection connection = null;
            if (url.substring(0, 5).toUpperCase().equals("HTTPS")) {
                HttpsURLConnection httpsConn = (HttpsURLConnection)realUrl.openConnection();
                httpsConn.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
                connection = httpsConn;
            } else {
                connection = realUrl.openConnection();
            }
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            if (requestMethod.equals("POST")) {
                connection.setDoOutput(true);
                connection.setDoInput(true);
                PrintWriter out = new PrintWriter(connection.getOutputStream());
                out.print(paramStr);
                out.flush();
            }
            connection.connect();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }
}

