/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.shopweb.response;

import org.slf4j.MDC;

public class BaseResult<T> {
    private Boolean isError;
    private T data;
    private String code;
    private String message;
    private String requestId = MDC.get((String)"requestId");

    public BaseResult() {
    }

    public Boolean getIsError() {
        return this.isError;
    }

    public void setIsError(Boolean isError) {
        this.isError = isError;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public BaseResult(Boolean isError, T data, String code, String message) {
        this.isError = isError;
        this.data = data;
        this.code = code;
        this.message = message;
        this.requestId = MDC.get((String)"requestId");
    }

    public static <T> BaseResult<T> getInstance(Boolean isError, T data, String code, String message) {
        return new BaseResult<T>(isError, data, code, message);
    }

    public static <T> BaseResult<T> invalidToken() {
        return BaseResult.getInstance(true, null, "-2", "\u65e0\u6548\u7684token");
    }

    public static <T> BaseResult<T> paramError() {
        return BaseResult.getInstance(true, null, "-1", "\u8bf7\u6c42\u53c2\u6570\u4f20\u9012\u9519\u8bef");
    }

    public static <T> BaseResult<T> exceptionError() {
        return BaseResult.getInstance(true, null, "99999", "\u8bf7\u6c42\u5f02\u5e38\u9519\u8bef");
    }

    public static <T> BaseResult<T> success() {
        return BaseResult.getInstance(false, null, "0", "\u8bf7\u6c42\u6570\u636e\u6210\u529f!");
    }

    public static <T> BaseResult<T> success(T data) {
        return BaseResult.getInstance(false, data, "0", "\u8bf7\u6c42\u6570\u636e\u6210\u529f!");
    }

    public static <T> BaseResult<T> error() {
        return BaseResult.getInstance(true, null, "1", "\u8bf7\u6c42\u6570\u636e\u5931\u8d25");
    }

    public static <T> BaseResult<T> error(String code, String message) {
        return BaseResult.getInstance(true, null, code, message);
    }

    public static <T> BaseResult<T> error(T data) {
        return BaseResult.getInstance(true, data, "1", "\u8bf7\u6c42\u6570\u636e\u5931\u8d25");
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public static abstract class CommonMessage {
        public static final String SUCCESS = "\u8bf7\u6c42\u6570\u636e\u6210\u529f!";
        public static final String ERROR = "\u8bf7\u6c42\u6570\u636e\u5931\u8d25";
        public static final String EXCEPTION = "\u8bf7\u6c42\u5f02\u5e38\u9519\u8bef";
        public static final String INVALID_TOKEN = "\u65e0\u6548\u7684token";
        public static final String PARAM_ERROR = "\u8bf7\u6c42\u53c2\u6570\u4f20\u9012\u9519\u8bef";
        public static final String BODY_NOT_MATCH = "\u8bf7\u6c42\u7684\u6570\u636e\u683c\u5f0f\u4e0d\u7b26!";
        public static final String INTERNAL_SERVER_ERROR = "\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef!";
        public static final String RESULT_DUPLICATE = "DUPLICATE";
        public static final String RESULT_FAILED = "FAILED";
        public static final String RESULT_INVALID_TOKEN = "INVALID_TOKEN";
        public static final String RESULT_SUCCESS = "ok";
        public static final String RESULT_OVER_TOO_MANY = "OVER_TOO_MANY";
        public static final String RESULT_EXPIRE = "EXPIRE";
        public static final String RESULT_NO_DATA = "NO_DATA";
        public static final String RESULT_NO_PERMISSION = "NO_PERMISSION";
        public static final String RESULT_EXCEPTION = "EXCEPTION";
        public static final String RESULT_INVALID_PARAMETER = "INVALID_PARAMETER";
        public static final String DATA_NOT_EXIST = "DATA_NOT_EXIST";
        public static final String RESULT_NOT_LOGIN = "LOGIN_OUT";
        public static final String RESULT_APPRECIATION_STATE_CANOT_DEL = "APPRECIATION_STATE_CANOT_DEL";
    }

    public static abstract class CommonCode {
        public static final String SUCCESS = "0";
        public static final String ERROR = "1";
        public static final String EXCEPTION = "99999";
        public static final String INVALID_TOKEN = "-2";
        public static final String PARAM_ERROR = "-1";
        public static final String BODY_NOT_MATCH = "400";
        public static final String INTERNAL_SERVER_ERROR = "500";
    }
}

