/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.shopweb.util;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtils {
    private static final Logger log = LoggerFactory.getLogger(IpUtils.class);

    public static String getIpAddress(HttpServletRequest request) {
        String[] split;
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip.contains(",")) {
            log.error("\u5ba2\u6237\u7aefip \u51fa\u73b0\u62fc\u63a5----------------------------\uff01\uff01\uff01\uff01\uff01{}", (Object)ip);
            split = ip.split(",");
            if (split.length == 1) {
                ip = split[0];
            }
            if (split.length > 1) {
                ip = split[1];
            }
        }
        if (ip.contains("\uff0c")) {
            log.error("\u5ba2\u6237\u7aefip \u51fa\u73b0\u62fc\u63a5-----------------------------\uff01\uff01\uff01\uff01\uff01{}", (Object)ip);
            split = ip.split("\uff0c");
            if (split.length == 1) {
                ip = split[0];
            }
            if (split.length > 1) {
                ip = split[1];
            }
        }
        return ip.trim();
    }

    public static final String getIpAddr(HttpServletRequest request) {
        String ip;
        block12: {
            block11: {
                ip = request.getHeader("X-Forwarded-For");
                log.info("getIpAddress(HttpServletRequest) - X-Forwarded-For - String ip=" + ip);
                if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip)) break block11;
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("Proxy-Client-IP");
                    if (log.isInfoEnabled()) {
                        log.info("getIpAddress(HttpServletRequest) - Proxy-Client-IP - String ip=" + ip);
                    }
                }
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("WL-Proxy-Client-IP");
                    if (log.isInfoEnabled()) {
                        log.info("getIpAddress(HttpServletRequest) - WL-Proxy-Client-IP - String ip=" + ip);
                    }
                }
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("HTTP_CLIENT_IP");
                    if (log.isInfoEnabled()) {
                        log.info("getIpAddress(HttpServletRequest) - HTTP_CLIENT_IP - String ip=" + ip);
                    }
                }
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("HTTP_X_FORWARDED_FOR");
                    if (log.isInfoEnabled()) {
                        log.info("getIpAddress(HttpServletRequest) - HTTP_X_FORWARDED_FOR - String ip=" + ip);
                    }
                }
                if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip)) break block12;
                ip = request.getRemoteAddr();
                if (log.isInfoEnabled()) {
                    log.info("getIpAddress(HttpServletRequest) - getRemoteAddr - String ip=" + ip);
                }
                break block12;
            }
            if (ip.length() > 15) {
                String[] ips = ip.split(",");
                for (int index = 0; index < ips.length; ++index) {
                    String strIp = ips[index];
                    if ("unknown".equalsIgnoreCase(strIp)) continue;
                    ip = strIp;
                    break;
                }
            }
        }
        return ip;
    }

    public static boolean isInnerIP(String ipAddress) {
        boolean isInnerIp = false;
        try {
            long ipNum = IpUtils.getIpNum(ipAddress);
            long aBegin = IpUtils.getIpNum("10.0.0.0");
            long aEnd = IpUtils.getIpNum("10.255.255.255");
            long bBegin = IpUtils.getIpNum("172.16.0.0");
            long bEnd = IpUtils.getIpNum("172.31.255.255");
            long cBegin = IpUtils.getIpNum("192.168.0.0");
            long cEnd = IpUtils.getIpNum("192.168.255.255");
            isInnerIp = IpUtils.isInner(ipNum, aBegin, aEnd) || IpUtils.isInner(ipNum, bBegin, bEnd) || IpUtils.isInner(ipNum, cBegin, cEnd) || "127.0.0.1".equals(ipAddress);
            return isInnerIp;
        }
        catch (Exception e) {
            return true;
        }
    }

    private static long getIpNum(String ipAddress) {
        String[] ip = ipAddress.split("\\.");
        long a = Integer.parseInt(ip[0]);
        long b = Integer.parseInt(ip[1]);
        long c = Integer.parseInt(ip[2]);
        long d = Integer.parseInt(ip[3]);
        long ipNum = a * 256L * 256L * 256L + b * 256L * 256L + c * 256L + d;
        return ipNum;
    }

    private static boolean isInner(long userIp, long begin, long end) {
        return userIp >= begin && userIp <= end;
    }

    public static void main(String[] args) {
        log.debug("true-or-false,{}", (Object)IpUtils.isInnerIP("221.224.63.26, 120.55.124.98"));
    }

    public static String getServerIp() {
        String localip = null;
        String netip = null;
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            boolean finded = false;
            block2: while (netInterfaces.hasMoreElements() && !finded) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> address = ni.getInetAddresses();
                while (address.hasMoreElements()) {
                    ip = address.nextElement();
                    if (!ip.isSiteLocalAddress() && !ip.isLoopbackAddress() && ip.getHostAddress().indexOf(":") == -1) {
                        netip = ip.getHostAddress();
                        finded = true;
                        continue block2;
                    }
                    if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") != -1) continue;
                    localip = ip.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        if (netip != null && !"".equals(netip)) {
            return netip;
        }
        return localip;
    }

    public static String getRemoteIp(HttpServletRequest request) {
        String remoteIp = request.getHeader("x-forwarded-for");
        if (!org.springframework.util.StringUtils.isEmpty((Object)remoteIp)) {
            String[] ips;
            for (String ip : ips = remoteIp.split(",")) {
                if ("null".equalsIgnoreCase(ip)) continue;
                return ip;
            }
        }
        return request.getRemoteAddr();
    }

    public static String getClientRealIp(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (StringUtils.isNotBlank((CharSequence)ip)) {
            return ip.split(",")[0];
        }
        return null;
    }
}

