/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.si.client.vo;

import com.ovopark.si.client.vo.FlowEdgeVo;
import com.ovopark.si.client.vo.FlowNodePartVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class FlowNodeVo {
    private Long id;
    private String name;
    private List<FlowNodePartVo> parts;
    private List<FlowEdgeVo> edges;

    public String getSymbolPrefix() {
        String symbol = this.parts.stream().map(FlowNodePartVo::getSymbol).findFirst().orElse(null);
        if (symbol == null) {
            return null;
        }
        if (symbol.startsWith("DML")) {
            return "DML";
        }
        return symbol.split("_")[0];
    }

    public List<Map<String, String>> getValues() {
        if (this.parts == null) {
            return null;
        }
        if (this.parts.stream().allMatch(p -> Objects.equals(p.getSymbol(), "STARTER"))) {
            return new ArrayList<Map<String, String>>();
        }
        return this.parts.stream().map(p -> {
            HashMap<String, String> map = new HashMap<String, String>();
            String s = p.getSymbol();
            if (s.startsWith("DML")) {
                map.put("value", s.replace("DML", ""));
            } else {
                map.put("value", s.split("_")[1]);
            }
            map.put("name", p.getName());
            return map;
        }).collect(Collectors.toList());
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<FlowNodePartVo> getParts() {
        return this.parts;
    }

    public List<FlowEdgeVo> getEdges() {
        return this.edges;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParts(List<FlowNodePartVo> parts) {
        this.parts = parts;
    }

    public void setEdges(List<FlowEdgeVo> edges) {
        this.edges = edges;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowNodeVo)) {
            return false;
        }
        FlowNodeVo other = (FlowNodeVo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<FlowNodePartVo> this$parts = this.getParts();
        List<FlowNodePartVo> other$parts = other.getParts();
        if (this$parts == null ? other$parts != null : !((Object)this$parts).equals(other$parts)) {
            return false;
        }
        List<FlowEdgeVo> this$edges = this.getEdges();
        List<FlowEdgeVo> other$edges = other.getEdges();
        return !(this$edges == null ? other$edges != null : !((Object)this$edges).equals(other$edges));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlowNodeVo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<FlowNodePartVo> $parts = this.getParts();
        result = result * 59 + ($parts == null ? 43 : ((Object)$parts).hashCode());
        List<FlowEdgeVo> $edges = this.getEdges();
        result = result * 59 + ($edges == null ? 43 : ((Object)$edges).hashCode());
        return result;
    }

    public String toString() {
        return "FlowNodeVo(id=" + this.getId() + ", name=" + this.getName() + ", parts=" + this.getParts() + ", edges=" + this.getEdges() + ")";
    }
}

