/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.si.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Generated;
import org.slf4j.MDC;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class R<T> {
    private Boolean isError;
    private T data;
    private Object hint;
    private int code;
    private String message;
    private String requestId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer pageNumber;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer pageSize;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Long total;

    public static <T> R<T> success() {
        return R.success(null);
    }

    public static <T> R<T> pageSuccess(int pageNumber, int pageSize, long total, T data) {
        R<T> r = R.success(data);
        r.total = total;
        r.pageNumber = pageNumber;
        r.pageSize = pageSize;
        return r;
    }

    public static <T> R<T> success(T data) {
        R<T> r = new R<T>();
        r.setData(data);
        r.setIsError(false);
        r.setCode(0);
        r.setMessage("success");
        return r;
    }

    public static R<?> error() {
        return R.error(null);
    }

    public static R<?> error(String message) {
        return R.error(message, null);
    }

    public static <T> R<T> error(int code, String message) {
        return R.error(code, message, null);
    }

    public static <T> R<T> error(String message, T data) {
        return R.error(1, message, data);
    }

    public static <T> R<T> error(int code, String message, T data) {
        return R.error(code, message, data, null);
    }

    public static <T> R<T> error(int code, String message, T data, Object hint) {
        R<T> r = new R<T>();
        r.setData(data);
        r.setIsError(true);
        r.setCode(code);
        r.setMessage(message);
        r.setHint(hint);
        return r;
    }

    public String getRequestId() {
        return MDC.get((String)"TRACE_ID");
    }

    @Generated
    public Boolean getIsError() {
        return this.isError;
    }

    @Generated
    public T getData() {
        return this.data;
    }

    @Generated
    public Object getHint() {
        return this.hint;
    }

    @Generated
    public int getCode() {
        return this.code;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    @Generated
    public Integer getPageSize() {
        return this.pageSize;
    }

    @Generated
    public Long getTotal() {
        return this.total;
    }

    @Generated
    public void setIsError(Boolean isError) {
        this.isError = isError;
    }

    @Generated
    public void setData(T data) {
        this.data = data;
    }

    @Generated
    public void setHint(Object hint) {
        this.hint = hint;
    }

    @Generated
    public void setCode(int code) {
        this.code = code;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    @Generated
    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    @Generated
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Generated
    public void setTotal(Long total) {
        this.total = total;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof R)) {
            return false;
        }
        R other = (R)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        Boolean this$isError = this.getIsError();
        Boolean other$isError = other.getIsError();
        if (this$isError == null ? other$isError != null : !((Object)this$isError).equals(other$isError)) {
            return false;
        }
        Integer this$pageNumber = this.getPageNumber();
        Integer other$pageNumber = other.getPageNumber();
        if (this$pageNumber == null ? other$pageNumber != null : !((Object)this$pageNumber).equals(other$pageNumber)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        Long this$total = this.getTotal();
        Long other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Object this$hint = this.getHint();
        Object other$hint = other.getHint();
        if (this$hint == null ? other$hint != null : !this$hint.equals(other$hint)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        return !(this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof R;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        Boolean $isError = this.getIsError();
        result = result * 59 + ($isError == null ? 43 : ((Object)$isError).hashCode());
        Integer $pageNumber = this.getPageNumber();
        result = result * 59 + ($pageNumber == null ? 43 : ((Object)$pageNumber).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        Long $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Object $hint = this.getHint();
        result = result * 59 + ($hint == null ? 43 : $hint.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "R(isError=" + this.getIsError() + ", data=" + this.getData() + ", hint=" + this.getHint() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", requestId=" + this.getRequestId() + ", pageNumber=" + this.getPageNumber() + ", pageSize=" + this.getPageSize() + ", total=" + this.getTotal() + ")";
    }
}

