/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.si.client.vo;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;

@JsonSerialize(using=TimeStrategySerializer.class)
@JsonDeserialize(using=TimeStrategyDeserializer.class)
public enum TimeStrategy {
    AFTERSECONDS,
    AFTERHOURS,
    NEXTDAYATHOURS,
    NEXTDAYATSECONDS;

    private Long value;

    public TimeStrategy setValue(Long value) {
        this.value = value;
        return this;
    }

    public Long getValue() {
        return this.value;
    }

    public String toString() {
        return this.name() + "_" + this.value;
    }

    public static class TimeStrategyDeserializer
    extends JsonDeserializer<TimeStrategy> {
        public TimeStrategy deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String[] split = p.getText().split("_");
            TimeStrategy timeStrategy = TimeStrategy.valueOf(split[0]);
            timeStrategy.setValue(Long.parseLong(split[1]));
            return timeStrategy;
        }
    }

    public static class TimeStrategySerializer
    extends JsonSerializer<TimeStrategy> {
        public void serialize(TimeStrategy value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.toString());
        }
    }
}

