/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.si.common;

import com.ovopark.si.common.Context;
import com.ovopark.si.common.User;
import com.ovopark.si.common.error.ErrorCode;
import com.ovopark.si.common.exception.BizException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

public class Department
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String name;
    private Long enterpriseId;
    private User manager;
    private String zone;
    private String outId;
    private Date createTime;
    private Double longitude;
    private Double latitude;
    private Integer validateStatus;
    private Integer timeZone;
    private Integer isSummerTime;
    private Date realSummerTimeStart;
    private Date realSummerTimeEnd;
    private Integer openStatus;

    public LocalDateTime getLocalNowTime() {
        return this.getLocalTime(LocalDateTime.now());
    }

    public LocalDateTime getLocalTime(LocalDateTime localDateTime) {
        Date date = Date.from(localDateTime.toInstant(ZoneOffset.ofHours(8)));
        Date localTime = this.getLocalTime(date);
        return LocalDateTime.ofInstant(localTime.toInstant(), ZoneOffset.ofHours(8));
    }

    public Date getLocalTime(Date date) {
        int DEFAULT_TIME_ZONE = 8;
        this.timeZone = this.timeZone != null ? this.timeZone : DEFAULT_TIME_ZONE;
        this.isSummerTime = this.isSummerTime == null ? 0 : this.isSummerTime;
        new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (this.timeZone <= 12) {
            cal.add(10, this.timeZone - DEFAULT_TIME_ZONE);
        } else {
            switch (this.timeZone) {
                case 13: {
                    cal.add(10, -9 - DEFAULT_TIME_ZONE);
                    cal.add(12, -30);
                    break;
                }
                case 14: {
                    cal.add(10, -3 - DEFAULT_TIME_ZONE);
                    cal.add(12, -30);
                    break;
                }
                case 15: {
                    cal.add(10, 3 - DEFAULT_TIME_ZONE);
                    cal.add(12, 30);
                    break;
                }
                case 16: {
                    cal.add(10, 4 - DEFAULT_TIME_ZONE);
                    cal.add(12, 30);
                    break;
                }
                case 17: {
                    cal.add(10, 5 - DEFAULT_TIME_ZONE);
                    cal.add(12, 30);
                    break;
                }
                case 18: {
                    cal.add(10, 6 - DEFAULT_TIME_ZONE);
                    cal.add(12, 30);
                    break;
                }
                case 19: {
                    cal.add(10, 9 - DEFAULT_TIME_ZONE);
                    cal.add(12, 30);
                    break;
                }
                case 20: {
                    cal.add(10, 10 - DEFAULT_TIME_ZONE);
                    cal.add(12, 30);
                    break;
                }
                case 21: {
                    cal.add(10, 13 - DEFAULT_TIME_ZONE);
                    break;
                }
                case 22: {
                    cal.add(10, 14 - DEFAULT_TIME_ZONE);
                }
            }
        }
        if (this.isDST(cal.getTime(), this.isSummerTime, this.realSummerTimeStart, this.realSummerTimeEnd)) {
            cal.add(10, 1);
        }
        return cal.getTime();
    }

    boolean isDST(Date now, Integer isSummerTime, Date summerTimeStart, Date summerTimeEnd) {
        boolean isDst = false;
        if (isSummerTime != null && isSummerTime > 0 && summerTimeStart != null && summerTimeEnd != null) {
            if (summerTimeEnd.after(summerTimeStart)) {
                if (!now.before(summerTimeStart) && now.before(summerTimeEnd)) {
                    isDst = true;
                }
            } else {
                isDst = !now.after(summerTimeEnd) || now.after(summerTimeStart);
            }
        }
        return isDst;
    }

    public void guard(Context ctx) {
        if (!Objects.equals(ctx.getEnterpriseId(), this.enterpriseId)) {
            throw new BizException(ErrorCode.PARAM_ERROR, "enterpriseId not match");
        }
    }

    public boolean isClosed() {
        return Objects.equals(2, this.getOpenStatus());
    }

    public boolean isOverdue() {
        return Objects.equals(1, this.validateStatus);
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Long getEnterpriseId() {
        return this.enterpriseId;
    }

    public User getManager() {
        return this.manager;
    }

    public String getZone() {
        return this.zone;
    }

    public String getOutId() {
        return this.outId;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Integer getValidateStatus() {
        return this.validateStatus;
    }

    public Integer getTimeZone() {
        return this.timeZone;
    }

    public Integer getIsSummerTime() {
        return this.isSummerTime;
    }

    public Date getRealSummerTimeStart() {
        return this.realSummerTimeStart;
    }

    public Date getRealSummerTimeEnd() {
        return this.realSummerTimeEnd;
    }

    public Integer getOpenStatus() {
        return this.openStatus;
    }

    public Department setId(Long id) {
        this.id = id;
        return this;
    }

    public Department setName(String name) {
        this.name = name;
        return this;
    }

    public Department setEnterpriseId(Long enterpriseId) {
        this.enterpriseId = enterpriseId;
        return this;
    }

    public Department setManager(User manager) {
        this.manager = manager;
        return this;
    }

    public Department setZone(String zone) {
        this.zone = zone;
        return this;
    }

    public Department setOutId(String outId) {
        this.outId = outId;
        return this;
    }

    public Department setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public Department setLongitude(Double longitude) {
        this.longitude = longitude;
        return this;
    }

    public Department setLatitude(Double latitude) {
        this.latitude = latitude;
        return this;
    }

    public Department setValidateStatus(Integer validateStatus) {
        this.validateStatus = validateStatus;
        return this;
    }

    public Department setTimeZone(Integer timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public Department setIsSummerTime(Integer isSummerTime) {
        this.isSummerTime = isSummerTime;
        return this;
    }

    public Department setRealSummerTimeStart(Date realSummerTimeStart) {
        this.realSummerTimeStart = realSummerTimeStart;
        return this;
    }

    public Department setRealSummerTimeEnd(Date realSummerTimeEnd) {
        this.realSummerTimeEnd = realSummerTimeEnd;
        return this;
    }

    public Department setOpenStatus(Integer openStatus) {
        this.openStatus = openStatus;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Department)) {
            return false;
        }
        Department other = (Department)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$enterpriseId = this.getEnterpriseId();
        Long other$enterpriseId = other.getEnterpriseId();
        if (this$enterpriseId == null ? other$enterpriseId != null : !((Object)this$enterpriseId).equals(other$enterpriseId)) {
            return false;
        }
        Double this$longitude = this.getLongitude();
        Double other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
            return false;
        }
        Double this$latitude = this.getLatitude();
        Double other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        Integer this$validateStatus = this.getValidateStatus();
        Integer other$validateStatus = other.getValidateStatus();
        if (this$validateStatus == null ? other$validateStatus != null : !((Object)this$validateStatus).equals(other$validateStatus)) {
            return false;
        }
        Integer this$timeZone = this.getTimeZone();
        Integer other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !((Object)this$timeZone).equals(other$timeZone)) {
            return false;
        }
        Integer this$isSummerTime = this.getIsSummerTime();
        Integer other$isSummerTime = other.getIsSummerTime();
        if (this$isSummerTime == null ? other$isSummerTime != null : !((Object)this$isSummerTime).equals(other$isSummerTime)) {
            return false;
        }
        Integer this$openStatus = this.getOpenStatus();
        Integer other$openStatus = other.getOpenStatus();
        if (this$openStatus == null ? other$openStatus != null : !((Object)this$openStatus).equals(other$openStatus)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        User this$manager = this.getManager();
        User other$manager = other.getManager();
        if (this$manager == null ? other$manager != null : !((Object)this$manager).equals(other$manager)) {
            return false;
        }
        String this$zone = this.getZone();
        String other$zone = other.getZone();
        if (this$zone == null ? other$zone != null : !this$zone.equals(other$zone)) {
            return false;
        }
        String this$outId = this.getOutId();
        String other$outId = other.getOutId();
        if (this$outId == null ? other$outId != null : !this$outId.equals(other$outId)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$realSummerTimeStart = this.getRealSummerTimeStart();
        Date other$realSummerTimeStart = other.getRealSummerTimeStart();
        if (this$realSummerTimeStart == null ? other$realSummerTimeStart != null : !((Object)this$realSummerTimeStart).equals(other$realSummerTimeStart)) {
            return false;
        }
        Date this$realSummerTimeEnd = this.getRealSummerTimeEnd();
        Date other$realSummerTimeEnd = other.getRealSummerTimeEnd();
        return !(this$realSummerTimeEnd == null ? other$realSummerTimeEnd != null : !((Object)this$realSummerTimeEnd).equals(other$realSummerTimeEnd));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Department;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $enterpriseId = this.getEnterpriseId();
        result = result * 59 + ($enterpriseId == null ? 43 : ((Object)$enterpriseId).hashCode());
        Double $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        Double $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        Integer $validateStatus = this.getValidateStatus();
        result = result * 59 + ($validateStatus == null ? 43 : ((Object)$validateStatus).hashCode());
        Integer $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : ((Object)$timeZone).hashCode());
        Integer $isSummerTime = this.getIsSummerTime();
        result = result * 59 + ($isSummerTime == null ? 43 : ((Object)$isSummerTime).hashCode());
        Integer $openStatus = this.getOpenStatus();
        result = result * 59 + ($openStatus == null ? 43 : ((Object)$openStatus).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        User $manager = this.getManager();
        result = result * 59 + ($manager == null ? 43 : ((Object)$manager).hashCode());
        String $zone = this.getZone();
        result = result * 59 + ($zone == null ? 43 : $zone.hashCode());
        String $outId = this.getOutId();
        result = result * 59 + ($outId == null ? 43 : $outId.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $realSummerTimeStart = this.getRealSummerTimeStart();
        result = result * 59 + ($realSummerTimeStart == null ? 43 : ((Object)$realSummerTimeStart).hashCode());
        Date $realSummerTimeEnd = this.getRealSummerTimeEnd();
        result = result * 59 + ($realSummerTimeEnd == null ? 43 : ((Object)$realSummerTimeEnd).hashCode());
        return result;
    }

    public String toString() {
        return "Department(id=" + this.getId() + ", name=" + this.getName() + ", enterpriseId=" + this.getEnterpriseId() + ", manager=" + this.getManager() + ", zone=" + this.getZone() + ", outId=" + this.getOutId() + ", createTime=" + this.getCreateTime() + ", longitude=" + this.getLongitude() + ", latitude=" + this.getLatitude() + ", validateStatus=" + this.getValidateStatus() + ", timeZone=" + this.getTimeZone() + ", isSummerTime=" + this.getIsSummerTime() + ", realSummerTimeStart=" + this.getRealSummerTimeStart() + ", realSummerTimeEnd=" + this.getRealSummerTimeEnd() + ", openStatus=" + this.getOpenStatus() + ")";
    }

    public Department() {
    }

    public Department(Long id, String name, Long enterpriseId, User manager, String zone, String outId, Date createTime, Double longitude, Double latitude, Integer validateStatus, Integer timeZone, Integer isSummerTime, Date realSummerTimeStart, Date realSummerTimeEnd, Integer openStatus) {
        this.id = id;
        this.name = name;
        this.enterpriseId = enterpriseId;
        this.manager = manager;
        this.zone = zone;
        this.outId = outId;
        this.createTime = createTime;
        this.longitude = longitude;
        this.latitude = latitude;
        this.validateStatus = validateStatus;
        this.timeZone = timeZone;
        this.isSummerTime = isSummerTime;
        this.realSummerTimeStart = realSummerTimeStart;
        this.realSummerTimeEnd = realSummerTimeEnd;
        this.openStatus = openStatus;
    }
}

