/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.si.common;

import com.ovopark.si.common.error.ErrorCode;
import com.ovopark.si.common.exception.BizException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Symbol {
    private static final List<String> allowPrefix = Arrays.asList("O", "S", "T", "U", "R");
    private String prefix;
    private Long id;

    public static Symbol from(String symbol) {
        try {
            String[] s = symbol.split("_");
            Symbol symbols = new Symbol();
            if (!allowPrefix.contains(s[0])) {
                throw new BizException(ErrorCode.PARAM_ERROR, "symbol\u683c\u5f0f\u9519\u8bef:" + symbol);
            }
            symbols.prefix = s[0];
            symbols.id = Long.parseLong(s[1]);
            return symbols;
        }
        catch (Exception e) {
            throw new BizException(ErrorCode.PARAM_ERROR, "symbol\u683c\u5f0f\u9519\u8bef:" + symbol);
        }
    }

    private Symbol(String prefix, Long id) {
        if (id == null) {
            throw new BizException(ErrorCode.PARAM_ERROR, "symbol id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.prefix = prefix;
        this.id = id;
    }

    private Symbol() {
    }

    public static Symbol org(Long id) {
        return new Symbol("O", id);
    }

    public static Symbol dep(Long id) {
        return new Symbol("S", id);
    }

    public static Symbol tag(Long id) {
        return new Symbol("T", id);
    }

    public static Symbol user(Long id) {
        return new Symbol("U", id);
    }

    public static Symbol role(Long id) {
        return new Symbol("R", id);
    }

    public boolean isOrg() {
        return "O".equals(this.prefix);
    }

    public boolean isDep() {
        return "S".equals(this.prefix);
    }

    public boolean isTag() {
        return "T".equals(this.prefix);
    }

    public boolean isUser() {
        return "U".equals(this.prefix);
    }

    public boolean isRole() {
        return "R".equals(this.prefix);
    }

    public boolean isUserOrRole() {
        return this.isUser() || this.isRole();
    }

    public boolean isDepOrOrgOrTag() {
        return this.isDep() || this.isOrg() || this.isTag();
    }

    public String toString() {
        return this.prefix + "_" + this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Symbol symbol = (Symbol)o;
        return Objects.equals(this.prefix, symbol.prefix) && Objects.equals(this.id, symbol.id);
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.id);
    }

    public Long getId() {
        return this.id;
    }
}

