/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.si.common.enhance;

import java.math.BigDecimal;

public class NumberUtils {
    public static BigDecimal calculateRate(Number data, Number divisor, int n) {
        return NumberUtils.calculateRate(false, data, divisor, n);
    }

    public static BigDecimal calculateRate(boolean divisorIs0ReturnsNull, Number data, Number divisor, int n) {
        if (data == null || divisor == null) {
            return null;
        }
        if (divisor.doubleValue() == 0.0) {
            if (divisorIs0ReturnsNull) {
                return null;
            }
            return BigDecimal.ZERO;
        }
        BigDecimal rate = new BigDecimal(data + "").multiply(new BigDecimal("100")).divide(new BigDecimal(divisor + ""), n, 4);
        return rate;
    }

    public static BigDecimal calculateGrowthRate(boolean divisorIs0ReturnsNull, Number thisData, Number lastData, int n) {
        if (thisData == null || lastData == null) {
            return null;
        }
        if (lastData.doubleValue() == 0.0) {
            if (divisorIs0ReturnsNull) {
                return null;
            }
            return BigDecimal.ZERO;
        }
        BigDecimal t = new BigDecimal(thisData.toString());
        BigDecimal d = new BigDecimal(lastData.toString());
        return t.subtract(d).multiply(new BigDecimal("100")).divide(d, n, 4);
    }

    public static BigDecimal calculateGrowthRate(Number thisData, Number lastData, int n) {
        return NumberUtils.calculateGrowthRate(false, thisData, lastData, n);
    }
}

