/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.si.common.enhance;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

public class JSON {
    public static String toJSONString(Object object, boolean prettyFormat) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.registerModule((Module)new JavaTimeModule());
        try {
            return prettyFormat ? objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(object) : objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new RuntimeException("toJSONString error", e);
        }
    }

    public static String toJSONString(Object object) {
        return JSON.toJSONString(object, false);
    }

    public static <T> T parseObject(String jsonString, Class<T> clazz) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            return (T)objectMapper.readValue(jsonString, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException("parseObject error", e);
        }
    }

    public static <T> T parseObject(JsonNode node, Class<T> clazz) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            return (T)objectMapper.treeToValue((TreeNode)node, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException("parseObject error", e);
        }
    }

    public static JsonNode readTree(String jsonString) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            return objectMapper.readTree(jsonString);
        }
        catch (Exception e) {
            throw new RuntimeException("readTree error", e);
        }
    }
}

