/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.si.common;

import com.ovopark.si.common.error.ErrorCode;
import com.ovopark.si.common.exception.BizException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Symbol {
    private static final List<String> allowPrefix = Arrays.asList("ID", "O", "S", "T", "U", "R");
    private static final List<String> allowPrefix2 = Arrays.asList("DM", "DML1", "DML2", "DML3", "DS", "DZM");
    private static final List<String> allowPrefix3 = Arrays.asList("INSP-TASK-TYPE", "INSP-TPL", "INSP-ITEM", "SOURCE");
    private static final List<String> allowPrefix4 = Collections.singletonList("STARTER");
    private String prefix;
    private String idStr;

    public static boolean depDynamicId(String prefix) {
        return allowPrefix2.contains(prefix);
    }

    public static boolean starterDynamicId(String prefix) {
        return allowPrefix4.contains(prefix);
    }

    public static Symbol from(String symbol) {
        try {
            if (symbol == null || symbol.isEmpty()) {
                throw new BizException(ErrorCode.PARAM_ERROR, "symbol\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String[] s = symbol.split("_");
            Symbol symbols = new Symbol();
            if (!(allowPrefix.contains(s[0]) || allowPrefix2.contains(s[0]) || allowPrefix3.contains(s[0]) || allowPrefix4.contains(s[0]))) {
                throw new BizException(ErrorCode.PARAM_ERROR, "symbol\u683c\u5f0f\u9519\u8bef:" + symbol);
            }
            symbols.prefix = s[0];
            if (s.length >= 2) {
                symbols.idStr = s[1];
            } else if (allowPrefix.contains(s[0])) {
                throw new BizException(ErrorCode.PARAM_ERROR, "symbol\u683c\u5f0f\u9519\u8bef:" + symbol);
            }
            return symbols;
        }
        catch (Exception e) {
            throw new BizException(ErrorCode.PARAM_ERROR, "symbol\u683c\u5f0f\u9519\u8bef:" + symbol);
        }
    }

    public static Symbol from(String prefix, Long id) {
        return Symbol.from(prefix + "_" + id);
    }

    private Symbol(String prefix, Long id) {
        if (id == null) {
            throw new BizException(ErrorCode.PARAM_ERROR, "symbol id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.prefix = prefix;
        this.idStr = id.toString();
    }

    private Symbol() {
    }

    public static Symbol org(Long id) {
        return new Symbol("O", id);
    }

    public static Symbol dep(Long id) {
        return new Symbol("S", id);
    }

    public static Symbol tag(Long id) {
        return new Symbol("T", id);
    }

    public static Symbol user(Long id) {
        return new Symbol("U", id);
    }

    public static Symbol role(Long id) {
        return new Symbol("R", id);
    }

    public boolean isOrg() {
        return "O".equals(this.prefix);
    }

    public boolean isDep() {
        return "S".equals(this.prefix);
    }

    public boolean isTag() {
        return "T".equals(this.prefix);
    }

    public boolean isUser() {
        return "U".equals(this.prefix);
    }

    public boolean isRole() {
        return "R".equals(this.prefix);
    }

    public boolean isUserOrRole() {
        return this.isUser() || this.isRole();
    }

    public boolean isDepOrOrgOrTag() {
        return this.isDep() || this.isOrg() || this.isTag();
    }

    public boolean isDepManager() {
        return "DM".equals(this.prefix);
    }

    public boolean isDepManagerLeader() {
        return Arrays.asList("DML1", "DML2", "DML3").contains(this.prefix);
    }

    public boolean isDML1() {
        return "DML1".equals(this.prefix);
    }

    public boolean isDML2() {
        return "DML2".equals(this.prefix);
    }

    public boolean isDML3() {
        return "DML3".equals(this.prefix);
    }

    public boolean isDepSupervisor() {
        return "DS".equals(this.prefix);
    }

    public boolean isDepZoneManager() {
        return "DZM".equals(this.prefix);
    }

    public boolean isRelated2User() {
        return this.isUserOrRole() || this.isDepManager() || this.isDepManagerLeader() || this.isDepSupervisor() || this.isDepZoneManager() || this.isDML1() || this.isDML2() || this.isDML3();
    }

    public Long getId() {
        return Long.parseLong(this.idStr);
    }

    public String toString() {
        return this.prefix + "_" + this.idStr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Symbol symbol = (Symbol)o;
        return Objects.equals(this.prefix, symbol.prefix) && Objects.equals(this.idStr, symbol.idStr);
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.idStr);
    }

    public String getIdStr() {
        return this.idStr;
    }
}

