/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.si.common;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ovopark.si.common.enhance.DateUtils;
import java.io.IOException;

@JsonSerialize(using=TimeStrategySerializer.class)
@JsonDeserialize(using=TimeStrategyDeserializer.class)
public enum TimeStrategy {
    AFTERSECONDS,
    AFTERHOURS,
    NEXTDAYATHOURS,
    NEXTDAYATSECONDS;

    private Long value;

    public TimeStrategy setValue(Long value) {
        this.value = value;
        return this;
    }

    public Long getValue() {
        return this.value;
    }

    public Long getSecondsFromNow() {
        if (this == AFTERSECONDS) {
            return this.value;
        }
        if (this == AFTERHOURS) {
            return this.value * 3600L;
        }
        if (this == NEXTDAYATHOURS) {
            return this.value * 3600L + DateUtils.restSecondsToday();
        }
        if (this == NEXTDAYATSECONDS) {
            return this.value + DateUtils.restSecondsToday();
        }
        return this.value;
    }

    public static TimeStrategy fromString(String value) {
        String[] split = value.split("_");
        TimeStrategy timeStrategy = TimeStrategy.valueOf(split[0]);
        timeStrategy.setValue(Long.parseLong(split[1]));
        return timeStrategy;
    }

    public String toString() {
        return this.name() + "_" + this.value;
    }

    public static class TimeStrategyDeserializer
    extends JsonDeserializer<TimeStrategy> {
        public TimeStrategy deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return TimeStrategy.fromString(p.getText());
        }
    }

    public static class TimeStrategySerializer
    extends JsonSerializer<TimeStrategy> {
        public void serialize(TimeStrategy value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.toString());
        }
    }
}

