/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.si.common;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ovopark.si.common.enhance.DateUtils;
import java.io.IOException;
import java.util.Objects;

@JsonSerialize(using=TimeStrategySerializer.class)
@JsonDeserialize(using=TimeStrategyDeserializer.class)
public class TimeStrategy {
    private static final String AFTERSECONDS = "AFTERSECONDS";
    private static final String AFTERHOURS = "AFTERHOURS";
    private static final String NEXTDAYATHOURS = "NEXTDAYATHOURS";
    private static final String NEXTDAYATSECONDS = "NEXTDAYATSECONDS";
    private String kind;
    private Long value;

    public Long getSecondsFromNow() {
        if (this.isAfterSeconds()) {
            return this.value;
        }
        if (this.isAfterHours()) {
            return this.value * 3600L;
        }
        if (this.isNextDayAtHours()) {
            return this.value * 3600L + DateUtils.restSecondsToday();
        }
        if (this.isNextDayAtSeconds()) {
            return this.value + DateUtils.restSecondsToday();
        }
        return this.value;
    }

    public boolean isAfterSeconds() {
        return Objects.equals(AFTERSECONDS, this.kind);
    }

    public boolean isAfterHours() {
        return Objects.equals(AFTERHOURS, this.kind);
    }

    public boolean isNextDayAtHours() {
        return Objects.equals(NEXTDAYATHOURS, this.kind);
    }

    public boolean isNextDayAtSeconds() {
        return Objects.equals(NEXTDAYATSECONDS, this.kind);
    }

    public static TimeStrategy afterSeconds(Long seconds) {
        return new TimeStrategy(AFTERSECONDS, seconds);
    }

    public static TimeStrategy afterHours(Long hours) {
        return new TimeStrategy(AFTERHOURS, hours);
    }

    public static TimeStrategy nextDayAtHours(Long hours) {
        return new TimeStrategy(NEXTDAYATHOURS, hours);
    }

    public static TimeStrategy nextDayAtSeconds(Long seconds) {
        return new TimeStrategy(NEXTDAYATSECONDS, seconds);
    }

    public static TimeStrategy fromString(String str) {
        String[] split = str.split("_");
        return new TimeStrategy(split[0], Long.parseLong(split[1]));
    }

    public String toString() {
        return this.kind + "_" + this.value;
    }

    public String getKind() {
        return this.kind;
    }

    public Long getValue() {
        return this.value;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public void setValue(Long value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeStrategy)) {
            return false;
        }
        TimeStrategy other = (TimeStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$value = this.getValue();
        Long other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        return !(this$kind == null ? other$kind != null : !this$kind.equals(other$kind));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TimeStrategy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        return result;
    }

    public TimeStrategy() {
    }

    public TimeStrategy(String kind, Long value) {
        this.kind = kind;
        this.value = value;
    }

    public static class TimeStrategyDeserializer
    extends JsonDeserializer<TimeStrategy> {
        public TimeStrategy deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return TimeStrategy.fromString(p.getText());
        }
    }

    public static class TimeStrategySerializer
    extends JsonSerializer<TimeStrategy> {
        public void serialize(TimeStrategy value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.toString());
        }
    }
}

