/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.si.common;

import com.ovopark.si.common.enhance.StringUtils;
import com.ovopark.si.common.error.ErrorCode;
import com.ovopark.si.common.exception.BizException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Symbol {
    private static final List<String> allowPrefix0 = Arrays.asList("ANY");
    private static final List<String> allowPrefix1 = Arrays.asList("ID", "O", "S", "T", "U", "R");
    private static final List<String> allowPrefix2 = Arrays.asList("DM", "DML1", "DML2", "DML3", "DS", "DZM");
    private static final List<String> allowPrefix3 = Arrays.asList("INSP-TASK-TYPE", "INSP-TPL", "INSP-ITEM", "SOURCE", "INSP-CAT");
    private static final List<String> allowPrefix4 = Arrays.asList("STARTER", "STARTERL");
    private static final List<String> allowPrefix5 = Arrays.asList("INSP-ITEM-PRIORITY", "MONEY", "SCORE_RATE", "SCORE");
    private static final List<String> allowPrefix6 = Arrays.asList("USERL");
    private String prefix;
    private String expression;

    public static boolean depDynamicId(String prefix) {
        return allowPrefix2.contains(prefix);
    }

    public static boolean isStarter(String prefix) {
        return Objects.equals("STARTER", prefix);
    }

    public static boolean isStarterLeader(String prefix) {
        return Objects.equals("STARTERL", prefix);
    }

    public static Symbol from(String symbol) {
        try {
            if (symbol == null || symbol.isEmpty()) {
                throw new BizException(ErrorCode.PARAM_ERROR, "symbol\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String[] s = symbol.split("_");
            Symbol symbols = new Symbol();
            if (!(allowPrefix0.contains(s[0]) || allowPrefix1.contains(s[0]) || allowPrefix2.contains(s[0]) || allowPrefix3.contains(s[0]) || allowPrefix4.contains(s[0]) || allowPrefix5.contains(s[0]) || allowPrefix6.contains(s[0]))) {
                throw new BizException(ErrorCode.PARAM_ERROR, "symbol\u683c\u5f0f\u9519\u8bef:" + symbol);
            }
            symbols.prefix = s[0];
            if (s.length >= 2) {
                symbols.expression = StringUtils.join((Object[])Arrays.copyOfRange(s, 1, s.length), (String)"_");
            } else if (allowPrefix1.contains(s[0])) {
                throw new BizException(ErrorCode.PARAM_ERROR, "symbol\u683c\u5f0f\u9519\u8bef:" + symbol);
            }
            return symbols;
        }
        catch (Exception e) {
            throw new BizException(ErrorCode.PARAM_ERROR, "symbol\u683c\u5f0f\u9519\u8bef:" + symbol);
        }
    }

    public static Symbol from(String prefix, Long id) {
        return Symbol.from(prefix + "_" + id);
    }

    private Symbol(String prefix, Long id) {
        if (id == null) {
            throw new BizException(ErrorCode.PARAM_ERROR, "symbol id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.prefix = prefix;
        this.expression = id.toString();
    }

    private Symbol() {
    }

    public static Symbol org(Long id) {
        return new Symbol("O", id);
    }

    public static Symbol dep(Long id) {
        return new Symbol("S", id);
    }

    public static Symbol tag(Long id) {
        return new Symbol("T", id);
    }

    public static Symbol user(Long id) {
        return new Symbol("U", id);
    }

    public static Symbol userLeader(Long id) {
        return new Symbol("UL", id);
    }

    public static Symbol role(Long id) {
        return new Symbol("R", id);
    }

    public boolean isOrg() {
        return "O".equals(this.prefix);
    }

    public boolean isDep() {
        return "S".equals(this.prefix);
    }

    public boolean isTag() {
        return "T".equals(this.prefix);
    }

    public boolean isUser() {
        return "U".equals(this.prefix);
    }

    public boolean isRole() {
        return "R".equals(this.prefix);
    }

    public boolean isUserOrRole() {
        return this.isUser() || this.isRole();
    }

    public boolean isDepOrOrgOrTag() {
        return this.isDep() || this.isOrg() || this.isTag();
    }

    public boolean isDepManager() {
        return "DM".equals(this.prefix);
    }

    public boolean isDepManagerLeader() {
        return Arrays.asList("DML1", "DML2", "DML3").contains(this.prefix);
    }

    public boolean isDML1() {
        return "DML1".equals(this.prefix);
    }

    public boolean isDML2() {
        return "DML2".equals(this.prefix);
    }

    public boolean isDML3() {
        return "DML3".equals(this.prefix);
    }

    public boolean isDepSupervisor() {
        return "DS".equals(this.prefix);
    }

    public boolean isDepZoneManager() {
        return "DZM".equals(this.prefix);
    }

    public boolean isRelated2User() {
        return this.isUserOrRole() || this.isDepManager() || this.isDepManagerLeader() || this.isDepSupervisor() || this.isDepZoneManager() || this.isDML1() || this.isDML2() || this.isDML3() || this.isUserLeader();
    }

    public boolean isUserLeader() {
        return "UL".equals(this.prefix);
    }

    public boolean isInspTaskType() {
        return "INSP-TASK-TYPE".equals(this.prefix);
    }

    public boolean isSource() {
        return "SOURCE".equals(this.prefix);
    }

    public boolean isAnyId() {
        return "ANY".equals(this.expression);
    }

    public boolean isAny() {
        return "ANY".equals(this.prefix);
    }

    public boolean isNotAnyId() {
        return !"ANY".equals(this.expression);
    }

    public boolean isInspTpl() {
        return "INSP-TPL".equals(this.prefix);
    }

    public boolean isInspItem() {
        return "INSP-ITEM".equals(this.prefix);
    }

    public boolean isInspCat() {
        return "INSP-CAT".equals(this.prefix);
    }

    public boolean isInspItemPriority() {
        return "INSP-ITEM-PRIORITY".equals(this.prefix);
    }

    public boolean isMoney() {
        return "MONEY".equals(this.prefix);
    }

    public static Symbol inspTpl(Long id) {
        return new Symbol("INSP-TPL", id);
    }

    public static Symbol inspItem(Long id) {
        return new Symbol("INSP-ITEM", id);
    }

    public static Symbol inspCat(Long id) {
        return new Symbol("INSP-CAT", id);
    }

    public boolean isConst() {
        return Arrays.asList("DM", "DML1", "DML2", "DML3", "DS", "DZM", "INSP-TASK-TYPE", "SOURCE", "STARTER", "STARTERL").contains(this.prefix);
    }

    public Long getId() {
        return Long.parseLong(this.expression);
    }

    public String toString() {
        return this.prefix + "_" + this.expression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Symbol symbol = (Symbol)o;
        return Objects.equals(this.prefix, symbol.prefix) && Objects.equals(this.expression, symbol.expression);
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.expression);
    }

    public String getExpression() {
        return this.expression;
    }
}

