/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.si.common;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;

@JsonSerialize(using=MoneySerializer.class)
@JsonDeserialize(using=MoneyDeserializer.class)
public class MoneyValue {
    public static final int scale = 1;
    private double amount = 0.0;
    public static final MoneyValue ZERO = new MoneyValue(0.0);

    public double doubleValue() {
        return this.amount;
    }

    public MoneyValue(double amount) {
        this.amount = amount;
    }

    public MoneyValue() {
    }

    public static class MoneyDeserializer
    extends JsonDeserializer<MoneyValue> {
        public MoneyValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return new MoneyValue(p.getDoubleValue());
        }
    }

    public static class MoneySerializer
    extends JsonSerializer<MoneyValue> {
        public void serialize(MoneyValue value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeNumber(new BigDecimal(value.amount).setScale(1, RoundingMode.HALF_UP));
        }
    }
}

