/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.si.common.enhance;

import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    public static final DateTimeFormatter DEFAULT_DTF = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final String DATE_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE = "yyyy-MM-dd";
    public static final String TIME = "HH:mm:ss";

    public static Date parseDate(String date, String ... parsePatterns) {
        try {
            return org.apache.commons.lang3.time.DateUtils.parseDate((String)date, (String[])parsePatterns);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Date parseDate(String date) {
        try {
            return org.apache.commons.lang3.time.DateUtils.parseDate((String)date, (String[])new String[]{DATE_TIME, DATE});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static long restSecondsToday() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime end = LocalDateTime.of(now.getYear(), now.getMonth(), now.getDayOfMonth(), 23, 59, 59);
        return Duration.between(now, end).getSeconds();
    }

    public static String formatDate(LocalDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.format(DateTimeFormatter.ofPattern(DATE_TIME));
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_TIME);
        return formatter.format(date);
    }

    public static String formatDateOneMonthAgo(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(DATE);
        Date oneMonthAgo = DateUtils.addMonths((Date)date, (int)-1);
        return formatter.format(oneMonthAgo);
    }

    public static String secondsConvertToDateStr(int seconds, String dayStr, String hourStr, String minuteStr, String secondStr) {
        StringBuffer str = new StringBuffer();
        if (seconds > 0) {
            int day = seconds / 86400;
            int hour = (seconds - 86400 * day) / 3600;
            int minute = (seconds - 86400 * day - 3600 * hour) / 60;
            int second = seconds - 86400 * day - 3600 * hour - 60 * minute;
            if (day > 0) {
                str.append(day).append(dayStr);
            }
            if (hour > 0) {
                str.append(hour).append(hourStr);
            }
            if (minute > 0) {
                str.append(minute).append(minuteStr);
            }
            if (second > 0) {
                str.append(second).append(secondStr);
            }
        } else {
            str.append(0 + secondStr);
        }
        return str.toString();
    }
}

