/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.si.common;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;

@JsonSerialize(using=ScoreSerializer.class)
@JsonDeserialize(using=ScoreDeserializer.class)
public class ScoreValue {
    public static final int scale = 1;
    private double score = 0.0;
    public static final ScoreValue ZERO = new ScoreValue(0.0);

    public double doubleValue() {
        return this.score;
    }

    public ScoreValue(double score) {
        this.score = score;
    }

    public ScoreValue() {
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScoreValue)) {
            return false;
        }
        ScoreValue other = (ScoreValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.getScore(), other.getScore()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScoreValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $score = Double.doubleToLongBits(this.getScore());
        result = result * 59 + (int)($score >>> 32 ^ $score);
        return result;
    }

    public String toString() {
        return "ScoreValue(score=" + this.getScore() + ")";
    }

    public static class ScoreDeserializer
    extends JsonDeserializer<ScoreValue> {
        public ScoreValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return new ScoreValue(p.getDoubleValue());
        }
    }

    public static class ScoreSerializer
    extends JsonSerializer<ScoreValue> {
        public void serialize(ScoreValue value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeNumber(new BigDecimal(value.score).setScale(1, RoundingMode.HALF_UP));
        }
    }
}

