/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.si.common;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;

@JsonSerialize(using=ScoreSerializer.class)
@JsonDeserialize(using=ScoreDeserializer.class)
public class ScoreRateValue {
    public static final int scale = 2;
    private double score = 0.0;
    public static final ScoreRateValue ZERO = new ScoreRateValue(0.0);

    public double doubleValue() {
        return this.score;
    }

    public ScoreRateValue(double score) {
        this.score = score;
    }

    public ScoreRateValue() {
    }

    public static class ScoreDeserializer
    extends JsonDeserializer<ScoreRateValue> {
        public ScoreRateValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return new ScoreRateValue(p.getDoubleValue());
        }
    }

    public static class ScoreSerializer
    extends JsonSerializer<ScoreRateValue> {
        public void serialize(ScoreRateValue value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeNumber(new BigDecimal(value.score).setScale(2, RoundingMode.HALF_UP));
        }
    }
}

