/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.si.common;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ovopark.si.common.enhance.DateUtils;
import java.io.IOException;
import java.util.Objects;

@JsonSerialize(using=TimeStrategySerializer.class)
@JsonDeserialize(using=TimeStrategyDeserializer.class)
public class TimeStrategy {
    public static final String AFTERSECONDS = "AFTERSECONDS";
    public static final String AFTERHOURS = "AFTERHOURS";
    public static final String NEXTDAYATHOURS = "NEXTDAYATHOURS";
    public static final String NEXTDAYATSECONDS = "NEXTDAYATSECONDS";
    public static final String EVERYMONTHONDAY = "EVERYMONTHONDAY";
    public static final String EVERYMONTHLASTDAY = "EVERYMONTHLASTDAY";
    private String kind;
    private Long value;

    public Long getSecondsFromNow() {
        if (this.isAfterSeconds()) {
            return this.value;
        }
        if (this.isAfterHours()) {
            return this.value * 3600L;
        }
        if (this.isNextDayAtHours()) {
            return this.value * 3600L + DateUtils.restSecondsToday();
        }
        if (this.isNextDayAtSeconds()) {
            return this.value + DateUtils.restSecondsToday();
        }
        if (this.isEveryMonthLastDay()) {
            return DateUtils.restSecondsToMonthEnd();
        }
        if (this.isEveryMonthOnDay()) {
            return DateUtils.restSecondsToMonthDay(this.value.intValue());
        }
        return this.value;
    }

    public boolean isAfterSeconds() {
        return Objects.equals(AFTERSECONDS, this.kind);
    }

    public boolean isAfterHours() {
        return Objects.equals(AFTERHOURS, this.kind);
    }

    public boolean isNextDayAtHours() {
        return Objects.equals(NEXTDAYATHOURS, this.kind);
    }

    public boolean isNextDayAtSeconds() {
        return Objects.equals(NEXTDAYATSECONDS, this.kind);
    }

    public boolean isEveryMonthOnDay() {
        return Objects.equals(EVERYMONTHONDAY, this.kind);
    }

    public boolean isEveryMonthLastDay() {
        return Objects.equals(EVERYMONTHLASTDAY, this.kind);
    }

    public static TimeStrategy afterSeconds(Long seconds) {
        return new TimeStrategy(AFTERSECONDS, seconds);
    }

    public static TimeStrategy afterHours(Long hours) {
        return new TimeStrategy(AFTERHOURS, hours);
    }

    public static TimeStrategy nextDayAtHours(Long hours) {
        return new TimeStrategy(NEXTDAYATHOURS, hours);
    }

    public static TimeStrategy nextDayAtSeconds(Long seconds) {
        return new TimeStrategy(NEXTDAYATSECONDS, seconds);
    }

    public static TimeStrategy everyMonthOnDay(Integer dayOfMonth) {
        if (dayOfMonth < 1 || dayOfMonth > 31) {
            throw new IllegalArgumentException("\u65e5\u671f\u5fc5\u987b\u57281-31\u4e4b\u95f4");
        }
        return new TimeStrategy(EVERYMONTHONDAY, dayOfMonth.longValue());
    }

    public static TimeStrategy everyMonthLastDay() {
        return new TimeStrategy(EVERYMONTHLASTDAY, 0L);
    }

    public static TimeStrategy fromString(String str) {
        String[] split = str.split("_");
        return new TimeStrategy(split[0], Long.parseLong(split[1]));
    }

    public String toString() {
        return this.kind + "_" + this.value;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeStrategy that = (TimeStrategy)o;
        return Objects.equals(this.kind, that.kind) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.kind, this.value);
    }

    public String getKind() {
        return this.kind;
    }

    public Long getValue() {
        return this.value;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public void setValue(Long value) {
        this.value = value;
    }

    public TimeStrategy() {
    }

    public TimeStrategy(String kind, Long value) {
        this.kind = kind;
        this.value = value;
    }

    public static class TimeStrategyDeserializer
    extends JsonDeserializer<TimeStrategy> {
        public TimeStrategy deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return TimeStrategy.fromString(p.getText());
        }
    }

    public static class TimeStrategySerializer
    extends JsonSerializer<TimeStrategy> {
        public void serialize(TimeStrategy value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.toString());
        }
    }
}

