/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.si;

import com.alibaba.fastjson.JSON;
import com.ovopark.si.DelayEvent;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.redisson.RedissonShutdownException;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RDelayedQueue;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DelayEventProcessor<T extends DelayEvent> {
    private static final Logger log = LoggerFactory.getLogger(DelayEventProcessor.class);
    static final long[] gradients = new long[]{10L, 60L, 300L, 600L, 3600L};
    static final String PREFIX = "R_DELAY_JQ:";
    RBlockingQueue<String> blockingQueue;
    RDelayedQueue<String> delayedQueue;
    Thread thread;
    protected RedissonClient redissonClient;
    private static volatile boolean running = true;

    void schedule(T event, long delayTime, TimeUnit timeUnit) {
        long realDelayTime = this.timeScale(delayTime);
        if (realDelayTime != delayTime) {
            log.error("\u65f6\u95f4\u7f29\u653e,{},\u539f\u59cb\u65f6\u95f4:{},\u7f29\u653e\u540e\u65f6\u95f4:{}", new Object[]{this.getQueueName(), delayTime, realDelayTime});
        }
        this.delayedQueue.offer((Object)JSON.toJSONString(event), this.timeScale(delayTime), timeUnit);
    }

    long timeScale(long time) {
        return time;
    }

    abstract void process(T var1);

    private void doProcess(T event) {
        log.info("\u5904\u7406\u5ef6\u8fdf\u4efb\u52a1 {} {}", (Object)event.getClass().getSimpleName(), (Object)JSON.toJSONString(event));
        try {
            this.process(event);
        }
        catch (Exception e) {
            if (this.retryable(event)) {
                long retryDelaySeconds = this.getRetryDelay(event);
                if (retryDelaySeconds > 0L) {
                    ((DelayEvent)event).incrRetryTimes();
                    this.schedule(event, retryDelaySeconds, TimeUnit.SECONDS);
                } else {
                    this.onFail(event);
                }
            } else {
                this.onFail(event);
            }
            log.error("\u5ef6\u8fdf\u4e8b\u4ef6\u4e1a\u52a1\u5904\u7406\u5931\u8d25: {} , {}", new Object[]{e.getMessage(), JSON.toJSONString(event), e});
        }
        log.info("\u961f\u5217\u957f\u5ea6 {},{}", (Object)this.delayedQueue.size(), (Object)this.blockingQueue.size());
    }

    long getRetryDelay(T event) {
        if (((DelayEvent)event).getRetryDelay() != null) {
            if (((DelayEvent)event).getRetryTimes() > this.maxRetryTimes()) {
                return -1L;
            }
            return ((DelayEvent)event).getRetryDelay();
        }
        int times = ((DelayEvent)event).getRetryTimes();
        if (times >= gradients.length || times < 0) {
            return -1L;
        }
        return gradients[times];
    }

    boolean retryable(T event) {
        return true;
    }

    int maxRetryTimes() {
        return gradients.length;
    }

    void onFail(T event) {
    }

    abstract String getQueueName();

    abstract Class<T> getEventClass();

    void verifyQueueName() {
        String LABEL_REGEX = "^[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9]$";
        Pattern pattern = Pattern.compile("^[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9]$");
        Matcher matcher = pattern.matcher(this.getQueueName());
        if (!matcher.matches()) {
            log.error("\u5ef6\u65f6\u961f\u5217 {} \u540d\u79f0\u4e0d\u7b26\u5408\u89c4\u8303,\u8bf7\u4fee\u6539", (Object)this.getQueueName());
            System.exit(2000);
        }
    }

    void start() {
        this.verifyQueueName();
        this.blockingQueue = this.redissonClient.getBlockingQueue(PREFIX + this.getQueueName());
        this.delayedQueue = this.redissonClient.getDelayedQueue(this.blockingQueue);
        this.thread = new Thread(() -> {
            while (running) {
                try {
                    this.doProcess((DelayEvent)JSON.parseObject((String)((String)this.blockingQueue.take()), this.getEventClass()));
                }
                catch (RedissonShutdownException e) {
                    log.error("redisson shutdown,{}", (Object)e.getMessage(), (Object)e);
                    running = false;
                }
                catch (Exception e) {
                    log.error("\u5ef6\u8fdf\u961f\u5217\u76d1\u542c\u7ebf\u7a0b\u5f02\u5e38,{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }, "delay-queue-listener-" + this.getQueueName());
        this.thread.start();
        log.info("{}\u5f00\u59cb\u76d1\u542c", (Object)this.getQueueName());
    }

    public void stop() {
        running = false;
        if (this.thread != null) {
            this.thread.interrupt();
        }
        log.info("{}\u505c\u6b62\u76d1\u542c", (Object)this.getQueueName());
    }
}

