/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.si;

import com.alibaba.fastjson.JSON;
import com.ovopark.si.DelayEvent;
import com.ovopark.si.DelayEventProcessor;
import com.ovopark.si.common.enhance.DateUtils;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;

public class DelayEventService
implements ApplicationListener<ApplicationStartedEvent> {
    private static final Logger log = LoggerFactory.getLogger(DelayEventService.class);
    private static DelayEventService instance;
    private final boolean enableListener;
    private final List<DelayEventProcessor<? extends DelayEvent>> processors;
    private final Map<Class<? extends DelayEvent>, DelayEventProcessor<? extends DelayEvent>> processorMap = new HashMap<Class<? extends DelayEvent>, DelayEventProcessor<? extends DelayEvent>>();

    public DelayEventService(List<DelayEventProcessor<? extends DelayEvent>> processors, boolean enableListener) {
        this.processors = processors;
        this.enableListener = enableListener;
        instance = this;
    }

    public DelayEventService(List<DelayEventProcessor<? extends DelayEvent>> processors) {
        this.processors = processors;
        this.enableListener = true;
        instance = this;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        this.startAll();
    }

    private <T extends DelayEvent> void schedule(T event, long delayTime, TimeUnit timeUnit) {
        DelayEventProcessor<? extends DelayEvent> processor = this.getProcessor(event.getClass());
        log.info("\u53d1\u5e03\u5ef6\u8fdf\u4efb\u52a1{} {}", (Object)event.getClass().getSimpleName(), (Object)JSON.toJSONString(event));
        processor.schedule(event, delayTime, timeUnit);
    }

    public static <T extends DelayEvent> void scheduleHours(T event, long hours) {
        event.setFireTime(DateUtils.addHours((Date)event.getCreateTime(), (int)((int)hours)));
        DelayEventService.getService().schedule(event, hours, TimeUnit.HOURS);
    }

    public static <T extends DelayEvent> void scheduleMinutes(T event, long mins) {
        event.setFireTime(DateUtils.addMinutes((Date)event.getCreateTime(), (int)((int)mins)));
        DelayEventService.getService().schedule(event, mins, TimeUnit.MINUTES);
    }

    public static <T extends DelayEvent> void scheduleSeconds(T event, long seconds) {
        event.setFireTime(DateUtils.addSeconds((Date)event.getCreateTime(), (int)((int)seconds)));
        DelayEventService.getService().schedule(event, seconds, TimeUnit.SECONDS);
    }

    public static <T extends DelayEvent> void scheduleDays(T event, long days) {
        event.setFireTime(DateUtils.addDays((Date)event.getCreateTime(), (int)((int)days)));
        DelayEventService.getService().schedule(event, days, TimeUnit.DAYS);
    }

    public void startAll() {
        this.processors.forEach(this::start);
    }

    public void stopAll() {
        this.processors.forEach(DelayEventProcessor::stop);
    }

    private DelayEventProcessor<? extends DelayEvent> getProcessor(Class<? extends DelayEvent> event) {
        return this.processorMap.get(event);
    }

    private static DelayEventService getService() {
        if (instance == null) {
            throw new RuntimeException("DelayEventService \u672a\u521d\u59cb\u5316");
        }
        return instance;
    }

    void start(DelayEventProcessor<? extends DelayEvent> processor) {
        Type t;
        if (processor.timeScale(1000L) != 1000L) {
            log.error("DelayEventProcessor {} \u975e\u6d4b\u8bd5\u73af\u5883\u4e0d\u5141\u8bb8\u7f29\u653e\u5ef6\u8fdf\u65f6\u95f4", (Object)processor.getClass().getName());
        }
        if ((t = processor.getClass().getGenericSuperclass()) instanceof ParameterizedType) {
            Class clz;
            boolean b;
            Type[] actualTypeArguments = ((ParameterizedType)t).getActualTypeArguments();
            if (actualTypeArguments.length != 1) {
                log.error("DelayEventProcessor {} \u6cdb\u578b\u53c2\u6570\u9519\u8bef", (Object)processor.getClass().getName());
                System.exit(2000);
            }
            if (!(b = Arrays.asList((clz = (Class)actualTypeArguments[0]).getGenericInterfaces()).contains(Serializable.class))) {
                log.error("DelayEvent {} must impl Serializable", (Object)clz.getName());
                System.exit(2000);
            }
            if (this.processorMap.containsKey(clz)) {
                log.error("DelayEventProcessor {} \u91cd\u590d", (Object)processor.getClass().getName());
                System.exit(2000);
            }
            this.processorMap.put(clz, processor);
        }
        processor.start();
    }
}

