/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.si;

import com.ovopark.si.DelayEvent;
import com.ovopark.si.DelayEventProcessor;
import com.ovopark.si.common.enhance.DateUtils;
import com.ovopark.si.common.enhance.JSON;
import com.ovopark.si.common.error.ErrorCode;
import com.ovopark.si.common.event.PreStopEvent;
import com.ovopark.si.common.exception.SysException;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class DelayEventService
implements ApplicationListener<ApplicationStartedEvent> {
    private static final Logger log = LoggerFactory.getLogger(DelayEventService.class);
    private final boolean enableListener;
    private final List<DelayEventProcessor<? extends DelayEvent>> processors;
    private final Map<Class<? extends DelayEvent>, DelayEventProcessor<? extends DelayEvent>> processorMap = new HashMap<Class<? extends DelayEvent>, DelayEventProcessor<? extends DelayEvent>>();

    @EventListener(value={PreStopEvent.class})
    public void preStop(PreStopEvent event) {
        this.stopAll();
    }

    public DelayEventService(List<DelayEventProcessor<? extends DelayEvent>> processors, boolean enableListener) {
        this.processors = processors;
        this.enableListener = enableListener;
    }

    public DelayEventService(List<DelayEventProcessor<? extends DelayEvent>> processors) {
        this.processors = processors;
        this.enableListener = false;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        if (this.enableListener) {
            this.startAll();
        }
    }

    private <T extends DelayEvent> void schedule(T event, long delayTime, TimeUnit timeUnit) {
        if (event.getFireTime() == null) {
            log.error("fireTime \u4e0d\u80fd\u4e3a\u7a7a");
            throw new SysException(ErrorCode.SYS_ERROR);
        }
        DelayEventProcessor<? extends DelayEvent> processor = this.getProcessor(event.getClass());
        log.info("\u53d1\u5e03\u5ef6\u8fdf\u4efb\u52a1{} {}", (Object)event.getClass().getSimpleName(), (Object)JSON.toJSONString(event));
        processor.schedule(event, delayTime, timeUnit);
    }

    public <T extends DelayEvent> void scheduleSeconds(T event, long seconds) {
        event.setFireTime(DateUtils.addSeconds((Date)event.getCreateTime(), (int)((int)seconds)));
        this.schedule(event, seconds, TimeUnit.SECONDS);
    }

    public <T extends DelayEvent> void scheduleMinutes(T event, long mins) {
        this.scheduleSeconds(event, mins * 60L);
    }

    public <T extends DelayEvent> void scheduleHours(T event, long hours) {
        this.scheduleMinutes(event, hours * 60L);
    }

    public <T extends DelayEvent> void scheduleDays(T event, long days) {
        this.scheduleHours(event, days * 24L);
    }

    public void startAll() {
        this.processors.forEach(this::start);
    }

    public void stopAll() {
        if (this.enableListener) {
            this.processors.forEach(DelayEventProcessor::stop);
        }
    }

    private DelayEventProcessor<? extends DelayEvent> getProcessor(Class<? extends DelayEvent> event) {
        return this.processorMap.get(event);
    }

    void start(DelayEventProcessor<? extends DelayEvent> processor) {
        Type t;
        if (processor.timeScale(1000L) != 1000L) {
            log.error("DelayEventProcessor {} \u975e\u6d4b\u8bd5\u73af\u5883\u4e0d\u5141\u8bb8\u7f29\u653e\u5ef6\u8fdf\u65f6\u95f4", (Object)processor.getClass().getName());
        }
        if ((t = processor.getClass().getGenericSuperclass()) instanceof ParameterizedType) {
            Class clz;
            boolean b;
            Type[] actualTypeArguments = ((ParameterizedType)t).getActualTypeArguments();
            if (actualTypeArguments.length != 1) {
                log.error("DelayEventProcessor {} \u6cdb\u578b\u53c2\u6570\u9519\u8bef", (Object)processor.getClass().getName());
                System.exit(2000);
            }
            if (!(b = Arrays.asList((clz = (Class)actualTypeArguments[0]).getGenericInterfaces()).contains(Serializable.class))) {
                log.error("DelayEvent {} must impl Serializable", (Object)clz.getName());
                System.exit(2000);
            }
            if (this.processorMap.containsKey(clz)) {
                log.error("DelayEventProcessor {} \u91cd\u590d", (Object)processor.getClass().getName());
                System.exit(2000);
            }
            this.processorMap.put(clz, processor);
        }
        processor.start();
    }
}

