/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.si;

import com.ovopark.si.DelayEventProcessor;
import com.ovopark.si.DelayEventWrapper;
import com.ovopark.si.common.enhance.JSON;
import com.ovopark.si.common.error.ErrorCode;
import com.ovopark.si.common.event.DelayEvent;
import com.ovopark.si.common.exception.SysException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class DelayEventService {
    private static final Logger log = LoggerFactory.getLogger(DelayEventService.class);
    private volatile boolean SUBSCRIBE_DELAY_EVENT = false;
    @Autowired
    private List<DelayEventProcessor<? extends DelayEvent>> processors;
    @Value(value="${DEV:false}")
    private Boolean DEV;
    private Map<Class<? extends DelayEvent>, DelayEventProcessor<? extends DelayEvent>> processorMap = new HashMap<Class<? extends DelayEvent>, DelayEventProcessor<? extends DelayEvent>>();

    @EventListener(value={DelayEventWrapper.class})
    public void onEvent(DelayEventWrapper wrapper) {
        this.schedule(wrapper.getEvent(), wrapper.getSeconds(), TimeUnit.SECONDS);
    }

    public void startSubscribe() {
        if (this.SUBSCRIBE_DELAY_EVENT) {
            return;
        }
        this.SUBSCRIBE_DELAY_EVENT = true;
        this.processors.forEach(this::start);
    }

    public void stopSubscribe() {
        if (this.SUBSCRIBE_DELAY_EVENT) {
            this.processors.forEach(DelayEventProcessor::stop);
        }
        this.SUBSCRIBE_DELAY_EVENT = false;
    }

    private <T extends DelayEvent> void schedule(T event, long delayTime, TimeUnit timeUnit) {
        if (event.getFireTime() == null) {
            log.error("fireTime \u4e0d\u80fd\u4e3a\u7a7a");
            throw new SysException(ErrorCode.SYS_ERROR);
        }
        DelayEventProcessor<? extends DelayEvent> processor = this.getProcessor(event.getClass());
        log.info("\u53d1\u5e03\u5ef6\u8fdf\u4efb\u52a1{} {}", (Object)event.getClass().getSimpleName(), (Object)JSON.toJSONString(event));
        processor.schedule(event, delayTime, timeUnit);
    }

    private DelayEventProcessor<? extends DelayEvent> getProcessor(Class<? extends DelayEvent> event) {
        return this.processorMap.get(event);
    }

    void start(DelayEventProcessor<? extends DelayEvent> processor) {
        Type t;
        if (processor.timeScale(1000L) != 1000L && !this.DEV.booleanValue()) {
            log.error("DelayEventProcessor {} \u975e\u6d4b\u8bd5\u73af\u5883\u4e0d\u5141\u8bb8\u7f29\u653e\u5ef6\u8fdf\u65f6\u95f4", (Object)processor.getClass().getName());
            System.exit(999);
        }
        if ((t = processor.getClass().getGenericSuperclass()) instanceof ParameterizedType) {
            Class clz;
            Type[] actualTypeArguments = ((ParameterizedType)t).getActualTypeArguments();
            if (actualTypeArguments.length != 1) {
                log.error("DelayEventProcessor {} \u6cdb\u578b\u53c2\u6570\u9519\u8bef", (Object)processor.getClass().getName());
                System.exit(2000);
            }
            if (this.processorMap.containsKey(clz = (Class)actualTypeArguments[0])) {
                log.error("DelayEventProcessor {} \u91cd\u590d", (Object)processor.getClass().getName());
                System.exit(2000);
            }
            this.processorMap.put(clz, processor);
        }
        processor.start();
    }
}

