/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.si;

import com.ovopark.si.DelayEventWrapper;
import com.ovopark.si.common.TimeStrategy;
import com.ovopark.si.common.enhance.DateUtils;
import com.ovopark.si.common.event.DelayEvent;
import java.util.Date;
import java.util.Objects;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class DelayEventScheduler {
    private final ApplicationEventPublisher publisher;

    public <T extends DelayEvent> void scheduleSeconds(T event, long seconds) {
        event.setFireTime(DateUtils.addSeconds((Date)event.getCreateTime(), (int)((int)seconds)));
        this.publisher.publishEvent(new DelayEventWrapper<T>(event, seconds));
    }

    public <T extends DelayEvent> void schedule(T event, TimeStrategy timeStrategy) {
        long secondsFromNow = timeStrategy.getSecondsFromNow();
        if (Objects.equals(event.getEnterpriseId(), 1567L)) {
            secondsFromNow /= 60L;
        }
        if (Objects.equals(event.getEnterpriseId(), 1084L)) {
            secondsFromNow /= 60L;
        }
        this.scheduleSeconds(event, secondsFromNow);
    }

    public <T extends DelayEvent> void scheduleMinutes(T event, long mins) {
        this.scheduleSeconds(event, mins * 60L);
    }

    public <T extends DelayEvent> void scheduleHours(T event, long hours) {
        this.scheduleMinutes(event, hours * 60L);
    }

    public <T extends DelayEvent> void scheduleDays(T event, long days) {
        this.scheduleHours(event, days * 24L);
    }

    public DelayEventScheduler(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }
}

