/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.si.rpc;

import com.alibaba.fastjson.JSON;
import com.ovopark.si.common.User;
import com.ovopark.si.common.error.ErrorCode;
import com.ovopark.si.common.exception.BizException;
import com.ovopark.si.common.exception.RpcException;
import com.ovopark.sso.api.TokenApi;
import com.ovopark.sso.model.BaseResult;
import com.ovopark.sso.model.TokenValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SsoService {
    private static final Logger log = LoggerFactory.getLogger(SsoService.class);
    private final TokenApi tokenApi;

    public User parseToken(String token) {
        BaseResult tokenV = this.tokenApi.parseToken(token, null);
        if (tokenV == null) {
            throw new RpcException("rpc call sso error");
        }
        if (tokenV.getIsError().booleanValue() || tokenV.getData() == null) {
            log.error("parse token error:{}", (Object)JSON.toJSONString((Object)tokenV));
            throw new BizException(ErrorCode.TOKEN_INVALID);
        }
        User user = new User();
        user.setId(((TokenValue)tokenV.getData()).getUserId());
        user.setName(((TokenValue)tokenV.getData()).getUserName());
        user.setGroupId(((TokenValue)tokenV.getData()).getGroupId());
        return user;
    }

    public SsoService(TokenApi tokenApi) {
        this.tokenApi = tokenApi;
    }
}

