/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.enhancer.utils;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);

    public static String getRemoteIp(HttpServletRequest request) {
        String realIp = request.getHeader("X-Real-IP");
        String remoteIp = request.getHeader("x-forwarded-for");
        if (StringUtils.isNotEmpty((CharSequence)realIp)) {
            log.debug("X-Real-IP:" + realIp);
        }
        if (StringUtils.isNotEmpty((CharSequence)remoteIp)) {
            log.debug("x-forwarded-for:" + remoteIp);
            if (remoteIp.contains(",")) {
                remoteIp = remoteIp.split(",")[0].trim();
            }
            return remoteIp;
        }
        return request.getRemoteAddr();
    }
}

