
# 配置说明

## 核心配置类 EhConfigurations

本配置类包含以下几个核心过滤器:

### 1. 上下文存储过滤器 (EhContextFilter)
- 功能: 存储和管理请求上下文信息
- 配置: enhancer.eh-context-filter.enable
- 默认: true
- 说明: 负责维护请求生命周期内的上下文数据

### 2. 请求日志过滤器 (EhLogFilter)
- 功能: 详细的请求日志记录
- 配置: enhancer.eh-log-filter.enable  
- 默认: true
- 记录内容:
  - HTTP Headers
  - 查询参数
  - 请求体
  - 客户端信息
  - 响应数据
  - 执行时间

### 3. 简单日志过滤器 (CommonsRequestLoggingFilter) 
- 功能: 基础请求日志记录
- 配置: enhancer.commons-request-logging-filter.enable
- 默认: false
- 说明: Spring内置的简单日志过滤器,仅记录基本请求信息

### 4. ThreadLocal清理过滤器 (EhClearFilter)
- 功能: 自动清理ThreadLocal
- 配置: enhancer.eh-clear-filter.enable
- 默认: true
- 说明: 防止内存泄漏,确保线程复用安全

## 全局配置
- 配置项: enhancer.enable
- 默认值: true
- 作用: 控制所有enhancer功能的总开关
- 优先级: 高于单个过滤器的配置
